/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.scheduler;

import com.netflix.fenzo.VirtualMachineLease;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.mesos.Utils;
import org.apache.flink.util.Preconditions;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Offer
implements VirtualMachineLease {
    private static final Logger logger = LoggerFactory.getLogger(Offer.class);
    private final Protos.Offer offer;
    private final String hostname;
    private final String vmID;
    private final long offeredTime;
    private final List<Protos.Resource> resources;
    private final Map<String, Double> aggregatedScalarResourceMap;
    private final Map<String, Protos.Attribute> attributeMap;
    private final double cpuCores;
    private final double memoryMB;
    private final double networkMbps;
    private final double diskMB;
    private final List<VirtualMachineLease.Range> portRanges;

    public Offer(Protos.Offer offer) {
        this.offer = (Protos.Offer)Preconditions.checkNotNull((Object)offer);
        this.hostname = offer.getHostname();
        this.vmID = offer.getSlaveId().getValue();
        this.offeredTime = System.currentTimeMillis();
        ArrayList<Protos.Resource> resources = new ArrayList<Protos.Resource>(offer.getResourcesList().size());
        HashMap<String, Double> aggregatedScalarResourceMap = new HashMap<String, Double>(){

            @Override
            public Double remove(Object key) {
                if (super.containsKey(key)) {
                    return (Double)super.remove(key);
                }
                return 0.0;
            }
        };
        HashMap<String, List<Protos.Resource>> rangesResourceMap = new HashMap<String, List<Protos.Resource>>();
        block4: for (Protos.Resource resource : offer.getResourcesList()) {
            switch (resource.getType()) {
                case SCALAR: {
                    resources.add(resource);
                    aggregatedScalarResourceMap.merge(resource.getName(), resource.getScalar().getValue(), Double::sum);
                    continue block4;
                }
                case RANGES: {
                    resources.add(resource);
                    rangesResourceMap.computeIfAbsent(resource.getName(), k -> new ArrayList(2)).add(resource);
                    continue block4;
                }
            }
            logger.debug("Unknown resource type " + resource.getType() + " for resource " + resource.getName() + " in offer, hostname=" + this.hostname + ", offerId=" + offer.getId());
        }
        this.resources = Collections.unmodifiableList(resources);
        this.cpuCores = (Double)aggregatedScalarResourceMap.remove("cpus");
        this.memoryMB = (Double)aggregatedScalarResourceMap.remove("mem");
        this.networkMbps = (Double)aggregatedScalarResourceMap.remove("network");
        this.diskMB = (Double)aggregatedScalarResourceMap.remove("disk");
        this.aggregatedScalarResourceMap = Collections.unmodifiableMap(aggregatedScalarResourceMap);
        this.portRanges = Collections.unmodifiableList(Offer.aggregateRangesResource(rangesResourceMap, "ports"));
        if (offer.getAttributesCount() > 0) {
            HashMap<String, Protos.Attribute> attributeMap = new HashMap<String, Protos.Attribute>();
            for (Protos.Attribute attribute : offer.getAttributesList()) {
                attributeMap.put(attribute.getName(), attribute);
            }
            this.attributeMap = Collections.unmodifiableMap(attributeMap);
        } else {
            this.attributeMap = Collections.emptyMap();
        }
    }

    public List<Protos.Resource> getResources() {
        return this.resources;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public String getVMID() {
        return this.vmID;
    }

    @Override
    public double cpuCores() {
        return this.cpuCores;
    }

    public double gpus() {
        return this.getScalarValue("gpus");
    }

    @Override
    public double memoryMB() {
        return this.memoryMB;
    }

    @Override
    public double networkMbps() {
        return this.networkMbps;
    }

    @Override
    public double diskMB() {
        return this.diskMB;
    }

    @Override
    public Protos.Offer getOffer() {
        return this.offer;
    }

    @Override
    public String getId() {
        return this.offer.getId().getValue();
    }

    @Override
    public long getOfferedTime() {
        return this.offeredTime;
    }

    @Override
    public List<VirtualMachineLease.Range> portRanges() {
        return this.portRanges;
    }

    @Override
    public Map<String, Protos.Attribute> getAttributeMap() {
        return this.attributeMap;
    }

    @Override
    public Double getScalarValue(String name) {
        return this.aggregatedScalarResourceMap.getOrDefault(name, 0.0);
    }

    @Override
    public Map<String, Double> getScalarValues() {
        return this.aggregatedScalarResourceMap;
    }

    public String toString() {
        return "Offer{offer=" + this.offer + ", resources='" + Utils.toString(this.resources) + '\'' + ", hostname='" + this.hostname + '\'' + ", vmID='" + this.vmID + '\'' + ", attributeMap=" + this.attributeMap + ", offeredTime=" + this.offeredTime + '}';
    }

    private static List<VirtualMachineLease.Range> aggregateRangesResource(Map<String, List<Protos.Resource>> resourceMap, String resourceName) {
        if (resourceMap.get(resourceName) == null) {
            return Collections.emptyList();
        }
        return resourceMap.get(resourceName).stream().flatMap(r -> r.getRanges().getRangeList().stream()).map(r -> new VirtualMachineLease.Range((int)r.getBegin(), (int)r.getEnd())).collect(Collectors.toList());
    }
}

