/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.scheduler;

import akka.actor.ActorRef;
import java.util.List;
import org.apache.flink.mesos.scheduler.messages.Disconnected;
import org.apache.flink.mesos.scheduler.messages.Error;
import org.apache.flink.mesos.scheduler.messages.ExecutorLost;
import org.apache.flink.mesos.scheduler.messages.FrameworkMessage;
import org.apache.flink.mesos.scheduler.messages.OfferRescinded;
import org.apache.flink.mesos.scheduler.messages.ReRegistered;
import org.apache.flink.mesos.scheduler.messages.Registered;
import org.apache.flink.mesos.scheduler.messages.ResourceOffers;
import org.apache.flink.mesos.scheduler.messages.SlaveLost;
import org.apache.flink.mesos.scheduler.messages.StatusUpdate;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;

public class SchedulerProxy
implements Scheduler {
    private final ActorRef mesosActor;

    public SchedulerProxy(ActorRef mesosActor) {
        this.mesosActor = mesosActor;
    }

    @Override
    public void registered(SchedulerDriver driver, Protos.FrameworkID frameworkId, Protos.MasterInfo masterInfo) {
        this.mesosActor.tell((Object)new Registered(frameworkId, masterInfo), ActorRef.noSender());
    }

    @Override
    public void reregistered(SchedulerDriver driver, Protos.MasterInfo masterInfo) {
        this.mesosActor.tell((Object)new ReRegistered(masterInfo), ActorRef.noSender());
    }

    @Override
    public void disconnected(SchedulerDriver driver) {
        this.mesosActor.tell((Object)new Disconnected(), ActorRef.noSender());
    }

    @Override
    public void resourceOffers(SchedulerDriver driver, List<Protos.Offer> offers) {
        this.mesosActor.tell((Object)new ResourceOffers(offers), ActorRef.noSender());
    }

    @Override
    public void offerRescinded(SchedulerDriver driver, Protos.OfferID offerId) {
        this.mesosActor.tell((Object)new OfferRescinded(offerId), ActorRef.noSender());
    }

    @Override
    public void statusUpdate(SchedulerDriver driver, Protos.TaskStatus status) {
        this.mesosActor.tell((Object)new StatusUpdate(status), ActorRef.noSender());
    }

    @Override
    public void frameworkMessage(SchedulerDriver driver, Protos.ExecutorID executorId, Protos.SlaveID slaveId, byte[] data) {
        this.mesosActor.tell((Object)new FrameworkMessage(executorId, slaveId, data), ActorRef.noSender());
    }

    @Override
    public void slaveLost(SchedulerDriver driver, Protos.SlaveID slaveId) {
        this.mesosActor.tell((Object)new SlaveLost(slaveId), ActorRef.noSender());
    }

    @Override
    public void executorLost(SchedulerDriver driver, Protos.ExecutorID executorId, Protos.SlaveID slaveId, int status) {
        this.mesosActor.tell((Object)new ExecutorLost(executorId, slaveId, status), ActorRef.noSender());
    }

    @Override
    public void error(SchedulerDriver driver, String message) {
        this.mesosActor.tell((Object)new Error(message), ActorRef.noSender());
    }
}

