/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.annotation.PropertyAccessor;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.core.Base64Variant;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.cfg.BaseSettings;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.cfg.ConfigFeature;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.type.ClassKey;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.type.TypeFactory;

public abstract class MapperConfigBase<CFG extends ConfigFeature, T extends MapperConfigBase<CFG, T>>
extends MapperConfig<T>
implements Serializable {
    private static final long serialVersionUID = 6062961959359172474L;
    private static final int DEFAULT_MAPPER_FEATURES = MapperConfigBase.collectFeatureDefaults(MapperFeature.class);
    protected final Map<ClassKey, Class<?>> _mixInAnnotations;
    protected final SubtypeResolver _subtypeResolver;
    protected final String _rootName;
    protected final Class<?> _view;
    protected final ContextAttributes _attributes;

    protected MapperConfigBase(BaseSettings base, SubtypeResolver str, Map<ClassKey, Class<?>> mixins) {
        super(base, DEFAULT_MAPPER_FEATURES);
        this._mixInAnnotations = mixins;
        this._subtypeResolver = str;
        this._rootName = null;
        this._view = null;
        this._attributes = ContextAttributes.getEmpty();
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src) {
        super(src);
        this._mixInAnnotations = src._mixInAnnotations;
        this._subtypeResolver = src._subtypeResolver;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, BaseSettings base) {
        super(base, src._mapperFeatures);
        this._mixInAnnotations = src._mixInAnnotations;
        this._subtypeResolver = src._subtypeResolver;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, int mapperFeatures) {
        super(src._base, mapperFeatures);
        this._mixInAnnotations = src._mixInAnnotations;
        this._subtypeResolver = src._subtypeResolver;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, SubtypeResolver str) {
        super(src);
        this._mixInAnnotations = src._mixInAnnotations;
        this._subtypeResolver = str;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, String rootName) {
        super(src);
        this._mixInAnnotations = src._mixInAnnotations;
        this._subtypeResolver = src._subtypeResolver;
        this._rootName = rootName;
        this._view = src._view;
        this._attributes = src._attributes;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, Class<?> view) {
        super(src);
        this._mixInAnnotations = src._mixInAnnotations;
        this._subtypeResolver = src._subtypeResolver;
        this._rootName = src._rootName;
        this._view = view;
        this._attributes = src._attributes;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, Map<ClassKey, Class<?>> mixins) {
        super(src);
        this._mixInAnnotations = mixins;
        this._subtypeResolver = src._subtypeResolver;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, ContextAttributes attr) {
        super(src);
        this._mixInAnnotations = src._mixInAnnotations;
        this._subtypeResolver = src._subtypeResolver;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = attr;
    }

    public abstract T with(AnnotationIntrospector var1);

    public abstract T withAppendedAnnotationIntrospector(AnnotationIntrospector var1);

    public abstract T withInsertedAnnotationIntrospector(AnnotationIntrospector var1);

    public abstract T with(ClassIntrospector var1);

    public abstract T with(DateFormat var1);

    public abstract T with(HandlerInstantiator var1);

    public abstract T with(PropertyNamingStrategy var1);

    public abstract T withRootName(String var1);

    public abstract T with(SubtypeResolver var1);

    public abstract T with(TypeFactory var1);

    public abstract T with(TypeResolverBuilder<?> var1);

    public abstract T withView(Class<?> var1);

    public abstract T with(VisibilityChecker<?> var1);

    public abstract T withVisibility(PropertyAccessor var1, JsonAutoDetect.Visibility var2);

    public abstract T with(Locale var1);

    public abstract T with(TimeZone var1);

    public abstract T with(Base64Variant var1);

    public abstract T with(ContextAttributes var1);

    public T withAttributes(Map<Object, Object> attributes) {
        return this.with(this.getAttributes().withSharedAttributes(attributes));
    }

    public T withAttribute(Object key, Object value) {
        return this.with(this.getAttributes().withSharedAttribute(key, value));
    }

    public T withoutAttribute(Object key) {
        return this.with(this.getAttributes().withoutSharedAttribute(key));
    }

    @Override
    public final SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public final String getRootName() {
        return this._rootName;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final ContextAttributes getAttributes() {
        return this._attributes;
    }

    @Override
    public final Class<?> findMixInClassFor(Class<?> cls) {
        return this._mixInAnnotations == null ? null : this._mixInAnnotations.get(new ClassKey(cls));
    }

    public final int mixInCount() {
        return this._mixInAnnotations == null ? 0 : this._mixInAnnotations.size();
    }
}

