/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.deser;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.PropertyMetadata;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.PropertyName;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.apache.flink.mesos.shaded.com.fasterxml.jackson.databind.util.Annotations;

public class CreatorProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedParameter _annotated;
    protected final Object _injectableValueId;
    protected final int _creatorIndex;
    protected final SettableBeanProperty _fallbackSetter;

    public CreatorProperty(PropertyName name, JavaType type, PropertyName wrapperName, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedParameter param, int index, Object injectableValueId, PropertyMetadata metadata) {
        super(name, type, wrapperName, typeDeser, contextAnnotations, metadata);
        this._annotated = param;
        this._creatorIndex = index;
        this._injectableValueId = injectableValueId;
        this._fallbackSetter = null;
    }

    @Deprecated
    public CreatorProperty(String name, JavaType type, PropertyName wrapperName, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedParameter param, int index, Object injectableValueId, boolean isRequired) {
        this(new PropertyName(name), type, wrapperName, typeDeser, contextAnnotations, param, index, injectableValueId, PropertyMetadata.construct(isRequired, null, null));
    }

    protected CreatorProperty(CreatorProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._annotated = src._annotated;
        this._creatorIndex = src._creatorIndex;
        this._injectableValueId = src._injectableValueId;
        this._fallbackSetter = src._fallbackSetter;
    }

    @Deprecated
    protected CreatorProperty(CreatorProperty src, String newName) {
        this(src, new PropertyName(newName));
    }

    protected CreatorProperty(CreatorProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._annotated = src._annotated;
        this._creatorIndex = src._creatorIndex;
        this._injectableValueId = src._injectableValueId;
        this._fallbackSetter = src._fallbackSetter;
    }

    protected CreatorProperty(CreatorProperty src, SettableBeanProperty fallbackSetter) {
        super(src);
        this._annotated = src._annotated;
        this._creatorIndex = src._creatorIndex;
        this._injectableValueId = src._injectableValueId;
        this._fallbackSetter = fallbackSetter;
    }

    @Override
    public CreatorProperty withName(PropertyName newName) {
        return new CreatorProperty(this, newName);
    }

    @Override
    public CreatorProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new CreatorProperty(this, deser);
    }

    public CreatorProperty withFallbackSetter(SettableBeanProperty fallbackSetter) {
        return new CreatorProperty(this, fallbackSetter);
    }

    public Object findInjectableValue(DeserializationContext context, Object beanInstance) {
        if (this._injectableValueId == null) {
            throw new IllegalStateException("Property '" + this.getName() + "' (type " + this.getClass().getName() + ") has no injectable value id configured");
        }
        return context.findInjectableValue(this._injectableValueId, this, beanInstance);
    }

    public void inject(DeserializationContext context, Object beanInstance) throws IOException {
        this.set(beanInstance, this.findInjectableValue(context, beanInstance));
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (this._annotated == null) {
            return null;
        }
        return this._annotated.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public int getCreatorIndex() {
        return this._creatorIndex;
    }

    @Override
    public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        this.set(instance, this.deserialize(jp, ctxt));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        return this.setAndReturn(instance, this.deserialize(jp, ctxt));
    }

    @Override
    public void set(Object instance, Object value) throws IOException {
        if (this._fallbackSetter == null) {
            throw new IllegalStateException("No fallback setter/field defined: can not use creator property for " + this.getClass().getName());
        }
        this._fallbackSetter.set(instance, value);
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        if (this._fallbackSetter == null) {
            throw new IllegalStateException("No fallback setter/field defined: can not use creator property for " + this.getClass().getName());
        }
        return this._fallbackSetter.setAndReturn(instance, value);
    }

    @Override
    public Object getInjectableValueId() {
        return this._injectableValueId;
    }

    @Override
    public String toString() {
        return "[creator property, name '" + this.getName() + "'; inject id '" + this._injectableValueId + "']";
    }
}

