/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.mesos.configuration.MesosOptions;
import org.apache.flink.mesos.util.MesosArtifactResolver;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInitializer;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.SocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpServerCodec;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Handler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Routed;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Router;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedStream;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedWriteHandler;
import org.apache.flink.shaded.netty4.io.netty.util.CharsetUtil;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class MesosArtifactServer
implements MesosArtifactResolver {
    private static final Logger LOG = LoggerFactory.getLogger(MesosArtifactServer.class);
    private final Router router;
    private ServerBootstrap bootstrap;
    private Channel serverChannel;
    private final URL baseURL;
    private final Map<Path, URL> paths = new HashMap<Path, URL>();
    private final SSLContext serverSSLContext;

    public MesosArtifactServer(String prefix, String serverHostname, int configuredPort, Configuration config) throws Exception {
        Channel ch;
        boolean enableSSL;
        if (configuredPort < 0 || configuredPort > 65535) {
            throw new IllegalArgumentException("File server port is invalid: " + configuredPort);
        }
        boolean bl = enableSSL = config.getBoolean(MesosOptions.ARTIFACT_SERVER_SSL_ENABLED) && SSLUtils.getSSLEnabled((Configuration)config);
        if (enableSSL) {
            LOG.info("Enabling ssl for the artifact server");
            try {
                this.serverSSLContext = SSLUtils.createSSLServerContext((Configuration)config);
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize SSLContext for the artifact server", e);
            }
        } else {
            this.serverSSLContext = null;
        }
        this.router = new Router();
        final Configuration sslConfig = config;
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                Handler handler = new Handler(MesosArtifactServer.this.router);
                if (MesosArtifactServer.this.serverSSLContext != null) {
                    SSLEngine sslEngine = MesosArtifactServer.this.serverSSLContext.createSSLEngine();
                    SSLUtils.setSSLVerAndCipherSuites((SSLEngine)sslEngine, (Configuration)sslConfig);
                    sslEngine.setUseClientMode(false);
                    ch.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new ChunkedWriteHandler()}).addLast(handler.name(), (ChannelHandler)handler).addLast(new ChannelHandler[]{new UnknownFileHandler()});
            }
        };
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)initializer);
        this.serverChannel = ch = this.bootstrap.bind(serverHostname, configuredPort).sync().channel();
        InetSocketAddress bindAddress = (InetSocketAddress)ch.localAddress();
        String address = bindAddress.getAddress().getHostAddress();
        int port = bindAddress.getPort();
        String httpProtocol = this.serverSSLContext != null ? "https" : "http";
        this.baseURL = new URL(httpProtocol, serverHostname, port, "/" + prefix + "/");
        LOG.info("Mesos Artifact Server Base URL: {}, listening at {}:{}", new Object[]{this.baseURL, address, port});
    }

    public URL baseURL() {
        return this.baseURL;
    }

    public synchronized int getServerPort() {
        Channel server = this.serverChannel;
        if (server != null) {
            try {
                return ((InetSocketAddress)server.localAddress()).getPort();
            }
            catch (Exception e) {
                LOG.error("Cannot access local server port", (Throwable)e);
            }
        }
        return -1;
    }

    public synchronized URL addFile(File localFile, String remoteFile) throws IOException, MalformedURLException {
        return this.addPath(new Path(localFile.toURI()), new Path(remoteFile));
    }

    public synchronized URL addPath(Path path, Path remoteFile) throws IOException, MalformedURLException {
        if (this.paths.containsKey(remoteFile)) {
            throw new IllegalArgumentException("duplicate path registered");
        }
        if (remoteFile.isAbsolute()) {
            throw new IllegalArgumentException("not expecting an absolute path");
        }
        URL fileURL = new URL(this.baseURL, remoteFile.toString());
        this.router.ANY(fileURL.getPath(), (Object)new VirtualFileServerHandler(path));
        this.paths.put(remoteFile, fileURL);
        return fileURL;
    }

    public synchronized void removePath(Path remoteFile) {
        if (this.paths.containsKey(remoteFile)) {
            URL fileURL = null;
            try {
                fileURL = new URL(this.baseURL, remoteFile.toString());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.router.removePath(fileURL.getPath());
        }
    }

    @Override
    public synchronized Option<URL> resolve(Path remoteFile) {
        Option resolved = Option.apply((Object)this.paths.get(remoteFile));
        return resolved;
    }

    public synchronized void stop() throws Exception {
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly();
            this.serverChannel = null;
        }
        if (this.bootstrap != null) {
            if (this.bootstrap.group() != null) {
                this.bootstrap.group().shutdownGracefully();
            }
            this.bootstrap = null;
        }
    }

    @ChannelHandler.Sharable
    public static class UnknownFileHandler
    extends SimpleChannelInboundHandler<Object> {
        protected void channelRead0(ChannelHandlerContext ctx, Object message) {
            UnknownFileHandler.sendNotFound(ctx);
        }

        private static void sendNotFound(ChannelHandlerContext ctx) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @ChannelHandler.Sharable
    public static class VirtualFileServerHandler
    extends SimpleChannelInboundHandler<Routed> {
        private FileSystem fs;
        private Path path;

        public VirtualFileServerHandler(Path path) throws IOException {
            this.path = path;
            if (!path.isAbsolute()) {
                throw new IllegalArgumentException("path must be absolute: " + path.toString());
            }
            this.fs = path.getFileSystem();
            if (!this.fs.exists(path) || this.fs.getFileStatus(path).isDir()) {
                throw new IllegalArgumentException("no such file: " + path.toString());
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, Routed routed) throws Exception {
            FileStatus status;
            HttpRequest request = routed.request();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} request for file '{}'", (Object)request.getMethod(), (Object)this.path);
            }
            if (request.getMethod() != HttpMethod.GET && request.getMethod() != HttpMethod.HEAD) {
                VirtualFileServerHandler.sendMethodNotAllowed(ctx);
                return;
            }
            try {
                status = this.fs.getFileStatus(this.path);
            }
            catch (IOException e) {
                LOG.error("unable to stat file", (Throwable)e);
                VirtualFileServerHandler.sendError(ctx, HttpResponseStatus.GONE);
                return;
            }
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpHeaders.setHeader((HttpMessage)response, (String)"Connection", (Object)"close");
            HttpHeaders.setHeader((HttpMessage)response, (String)"Cache-Control", (Object)"private");
            HttpHeaders.setHeader((HttpMessage)response, (String)"Content-Type", (Object)"application/octet-stream");
            HttpHeaders.setContentLength((HttpMessage)response, (long)status.getLen());
            ctx.write((Object)response);
            if (request.getMethod() == HttpMethod.GET) {
                FSDataInputStream stream = this.fs.open(this.path);
                try {
                    ctx.write((Object)new ChunkedStream((InputStream)stream));
                }
                catch (Exception e) {
                    stream.close();
                    throw e;
                }
            }
            ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx.channel().isActive()) {
                LOG.error("Caught exception", cause);
                VirtualFileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }

        private static void sendMethodNotAllowed(ChannelHandlerContext ctx) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setHeader((HttpMessage)response, (String)"Content-Type", (Object)"text/plain; charset=UTF-8");
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

