/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.flink.util.Preconditions;
import org.apache.mesos.MesosSchedulerDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;
import org.slf4j.Logger;
import scala.Option;

public class MesosConfiguration {
    private final String masterUrl;
    private final Protos.FrameworkInfo.Builder frameworkInfo;
    private final Option<Protos.Credential.Builder> credential;

    public MesosConfiguration(String masterUrl, Protos.FrameworkInfo.Builder frameworkInfo, Option<Protos.Credential.Builder> credential) {
        this.masterUrl = (String)Preconditions.checkNotNull((Object)masterUrl);
        this.frameworkInfo = (Protos.FrameworkInfo.Builder)Preconditions.checkNotNull((Object)frameworkInfo);
        this.credential = (Option)Preconditions.checkNotNull(credential);
    }

    public String masterUrl() {
        return this.masterUrl;
    }

    public Protos.FrameworkInfo.Builder frameworkInfo() {
        return this.frameworkInfo;
    }

    public Option<Protos.Credential.Builder> credential() {
        return this.credential;
    }

    public MesosConfiguration withFrameworkInfo(Protos.FrameworkInfo.Builder frameworkInfo) {
        return new MesosConfiguration(this.masterUrl, frameworkInfo, this.credential);
    }

    public Set<String> roles() {
        return this.frameworkInfo.hasRole() && !"*".equals(this.frameworkInfo.getRole()) ? Collections.singleton(this.frameworkInfo.getRole()) : Collections.emptySet();
    }

    public SchedulerDriver createDriver(Scheduler scheduler, boolean implicitAcknowledgements) {
        MesosSchedulerDriver schedulerDriver = this.credential().isDefined() ? new MesosSchedulerDriver(scheduler, this.frameworkInfo.build(), this.masterUrl(), implicitAcknowledgements, ((Protos.Credential.Builder)this.credential().get()).build()) : new MesosSchedulerDriver(scheduler, this.frameworkInfo.build(), this.masterUrl(), implicitAcknowledgements);
        return schedulerDriver;
    }

    public String toString() {
        return "MesosConfiguration{masterUrl='" + this.masterUrl + '\'' + ", frameworkInfo=" + this.frameworkInfo + ", credential=" + (this.credential.isDefined() ? "(not shown)" : "(none)") + '}';
    }

    public static void logMesosConfig(Logger log, MesosConfiguration config) {
        Map<String, String> env = System.getenv();
        Protos.FrameworkInfo.Builder info = config.frameworkInfo();
        log.info("--------------------------------------------------------------------------------");
        log.info(" Mesos Info:");
        log.info("    Master URL: {}", (Object)config.masterUrl());
        log.info(" Framework Info:");
        log.info("    ID: {}", (Object)(info.hasId() ? info.getId().getValue() : "(none)"));
        log.info("    Name: {}", (Object)(info.hasName() ? info.getName() : "(none)"));
        log.info("    Failover Timeout (secs): {}", (Object)info.getFailoverTimeout());
        log.info("    Role: {}", (Object)(info.hasRole() ? info.getRole() : "(none)"));
        log.info("    Capabilities: {}", info.getCapabilitiesList().size() > 0 ? info.getCapabilitiesList() : "(none)");
        log.info("    Principal: {}", (Object)(info.hasPrincipal() ? info.getPrincipal() : "(none)"));
        log.info("    Host: {}", (Object)(info.hasHostname() ? info.getHostname() : "(none)"));
        if (env.containsKey("LIBPROCESS_IP")) {
            log.info("    LIBPROCESS_IP: {}", (Object)env.get("LIBPROCESS_IP"));
        }
        if (env.containsKey("LIBPROCESS_PORT")) {
            log.info("    LIBPROCESS_PORT: {}", (Object)env.get("LIBPROCESS_PORT"));
        }
        log.info("    Web UI: {}", (Object)(info.hasWebuiUrl() ? info.getWebuiUrl() : "(none)"));
        log.info("--------------------------------------------------------------------------------");
    }
}

