/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.flink.mesos.Utils;
import org.apache.flink.util.Preconditions;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MesosResourceAllocation {
    protected static final Logger LOG = LoggerFactory.getLogger(MesosResourceAllocation.class);
    static final double EPSILON = 1.0E-5;
    private final List<Protos.Resource> resources;

    public MesosResourceAllocation(Collection<Protos.Resource> resources) {
        this.resources = new ArrayList<Protos.Resource>((Collection)Preconditions.checkNotNull(resources));
        this.resources.sort(Comparator.comparing(r -> "*".equals(r.getRole())));
    }

    public List<Protos.Resource> getRemaining() {
        return Collections.unmodifiableList(this.resources);
    }

    public List<Protos.Resource> takeScalar(String resourceName, double amount, Set<String> roles) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Allocating {} {}", (Object)amount, (Object)resourceName);
        }
        ArrayList<Protos.Resource> result = new ArrayList<Protos.Resource>(1);
        ListIterator<Protos.Resource> i = this.resources.listIterator();
        while (i.hasNext() && !(amount <= 1.0E-5)) {
            double remaining;
            Protos.Resource available = i.next();
            if (!resourceName.equals(available.getName()) || !available.hasScalar() || !"*".equals(available.getRole()) && !roles.contains(available.getRole())) continue;
            double amountToTake = Math.min(available.getScalar().getValue(), amount);
            Protos.Resource taken = available.toBuilder().setScalar(Protos.Value.Scalar.newBuilder().setValue(amountToTake)).build();
            amount -= amountToTake;
            result.add(taken);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Taking {} from {}", (Object)amountToTake, (Object)Utils.toString(available));
            }
            if ((remaining = available.getScalar().getValue() - taken.getScalar().getValue()) > 1.0E-5) {
                i.set(available.toBuilder().setScalar(Protos.Value.Scalar.newBuilder().setValue(remaining)).build());
                continue;
            }
            i.remove();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Allocated: {}, unsatisfied: {}", (Object)Utils.toString(result), (Object)amount);
        }
        return result;
    }

    public List<Protos.Resource> takeRanges(String resourceName, int amount, Set<String> roles) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Allocating {} {}", (Object)amount, (Object)resourceName);
        }
        ArrayList<Protos.Resource> result = new ArrayList<Protos.Resource>(1);
        ListIterator<Protos.Resource> i = this.resources.listIterator();
        while (i.hasNext() && amount > 0) {
            Protos.Resource available = i.next();
            if (!resourceName.equals(available.getName()) || !available.hasRanges() || !"*".equals(available.getRole()) && !roles.contains(available.getRole())) continue;
            ArrayList<Protos.Value.Range> takenRanges = new ArrayList<Protos.Value.Range>();
            ArrayList<Protos.Value.Range> remainingRanges = new ArrayList<Protos.Value.Range>(available.getRanges().getRangeList());
            ListIterator<Protos.Value.Range> j = remainingRanges.listIterator();
            while (j.hasNext() && amount > 0) {
                Protos.Value.Range availableRange = (Protos.Value.Range)j.next();
                long amountToTake = Math.min(availableRange.getEnd() - availableRange.getBegin() + 1L, (long)amount);
                Protos.Value.Range takenRange = availableRange.toBuilder().setEnd(availableRange.getBegin() + amountToTake - 1L).build();
                amount = (int)((long)amount - amountToTake);
                takenRanges.add(takenRange);
                long remaining = availableRange.getEnd() - takenRange.getEnd();
                if (remaining > 0L) {
                    j.set(availableRange.toBuilder().setBegin(takenRange.getEnd() + 1L).build());
                    continue;
                }
                j.remove();
            }
            Protos.Resource taken = available.toBuilder().setRanges(Protos.Value.Ranges.newBuilder().addAllRange(takenRanges)).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Taking {} from {}", (Object)Utils.toString(taken.getRanges()), (Object)Utils.toString(available));
            }
            result.add(taken);
            if (remainingRanges.size() > 0) {
                i.set(available.toBuilder().setRanges(Protos.Value.Ranges.newBuilder().addAllRange(remainingRanges)).build());
                continue;
            }
            i.remove();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Allocated: {}, unsatisfied: {}", (Object)Utils.toString(result), (Object)amount);
        }
        return result;
    }

    public String toString() {
        return "MesosResourceAllocation{resources=" + Utils.toString(this.resources) + '}';
    }
}

