/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.discovery.actuate.endpoint;

import com.alibaba.boot.nacos.common.PropertiesUtils;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.spring.factory.CacheableEventPublishingNacosServiceFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;

@Endpoint(id="nacos-discovery")
public class NacosDiscoveryEndpoint {
    @Autowired
    private ApplicationContext applicationContext;
    private static final Integer PAGE_SIZE = 100;

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("nacosDiscoveryGlobalProperties", PropertiesUtils.extractSafeProperties((Properties)((Properties)this.applicationContext.getBean("globalNacosProperties$discovery", Properties.class))));
        CacheableEventPublishingNacosServiceFactory nacosServiceFactory = CacheableEventPublishingNacosServiceFactory.getSingleton();
        ArrayNode array = JacksonUtils.createEmptyArrayNode();
        for (NamingService namingService : nacosServiceFactory.getNamingServices()) {
            ObjectNode jsonObject = JacksonUtils.createEmptyJsonNode();
            try {
                jsonObject.putPOJO("servicesOfServer", (Object)namingService.getServicesOfServer(0, PAGE_SIZE.intValue()));
                jsonObject.putPOJO("subscribeServices", (Object)namingService.getSubscribeServices());
                array.add((JsonNode)jsonObject);
            }
            catch (Exception e) {
                jsonObject.put("serverStatus", namingService.getServerStatus() + ": " + "|" + e.getMessage());
            }
        }
        result.put("namingServersStatus", array);
        return result;
    }
}

