/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.location;

import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.location.AccessLocationMatcher;
import com.alibaba.bytekit.asm.location.Location;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.FieldInsnNode;
import java.util.ArrayList;
import java.util.List;

public class FieldAccessLocationMatcher
extends AccessLocationMatcher {
    private String ownerClass;
    private String fieldName;
    private String fieldDesc;

    public FieldAccessLocationMatcher(String ownerClass, String fieldDesc, String fieldName, int count, int flags, boolean whenComplete) {
        super(count, flags, whenComplete);
        this.ownerClass = ownerClass;
        this.fieldDesc = fieldDesc;
        this.fieldName = fieldName;
    }

    @Override
    public List<Location> match(MethodProcessor methodProcessor) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int matchedCount = 0;
        for (AbstractInsnNode insnNode = methodProcessor.getEnterInsnNode(); insnNode != null; insnNode = insnNode.getNext()) {
            FieldInsnNode fieldInsnNode;
            if (!(insnNode instanceof FieldInsnNode) || !this.matchField(fieldInsnNode = (FieldInsnNode)insnNode) || this.count > 0 && this.count != ++matchedCount) continue;
            Location.FieldAccessLocation fieldAccessLocation = new Location.FieldAccessLocation(fieldInsnNode, this.count, this.flags, this.whenComplete);
            locations.add(fieldAccessLocation);
        }
        return locations;
    }

    private boolean matchField(FieldInsnNode fieldInsnNode) {
        if (!this.fieldName.equals(fieldInsnNode.name)) {
            return false;
        }
        if (this.fieldDesc != null && !this.fieldDesc.equals(fieldInsnNode.desc)) {
            return false;
        }
        switch (fieldInsnNode.getOpcode()) {
            case 178: 
            case 180: {
                if ((this.flags & 1) != 0) break;
                return false;
            }
            case 179: 
            case 181: {
                if ((this.flags & 2) != 0) break;
                return false;
            }
        }
        return this.ownerClass == null || this.ownerClass.equals(fieldInsnNode.owner);
    }
}

