package com.example;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.binding.Binding;
import com.alibaba.bytekit.asm.binding.LocalVarNamesBinding;
import com.alibaba.bytekit.asm.binding.LocalVarsBinding;
import com.alibaba.bytekit.asm.binding.ThisBinding;
import com.alibaba.bytekit.asm.interceptor.InterceptorMethodConfig;
import com.alibaba.bytekit.asm.interceptor.InterceptorProcessor;
import com.alibaba.bytekit.asm.interceptor.annotation.AtInvoke;
import com.alibaba.bytekit.asm.interceptor.annotation.InterceptorParserUtils;
import com.alibaba.bytekit.asm.interceptor.parser.DefaultInterceptorClassParser;
import com.alibaba.bytekit.asm.location.LineLocationMatcher;
import com.alibaba.bytekit.utils.AgentUtils;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.bytekit.utils.Decompiler;
import com.alibaba.deps.org.objectweb.asm.tree.ClassNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;

public class AynLineDemo {
    
    private String ttt;

    public static class MicroService {

        public void interfaceA(String strA){
            System.out.println("interfaceA" + strA);

            String strb  = strA + "BBB";
            interfaceB(strb);
        }

        public void interfaceB(String strB){
            System.out.println("interfaceB" + strB);
        }

    }


    public static class TestAccessInterceptor {
        @AtInvoke(name = "interfaceB", inline = false, whenComplete = false)
        public static void onInvokeAfter(
                @Binding.This Object object,
                @Binding.Class Object clazz,
                @Binding.MethodName String methodName,
                @Binding.InvokeMethodName String invokeMethodName,
                @Binding.InvokeArgs Object[] args,
                @Binding.InvokeReturn Object invokeReturn,
                @Binding.InvokeMethodDeclaration String declaration
        ) {
            System.err.println("onInvokeAfter: this" + object);
            System.err.println("methodName: " + methodName);
            System.err.println("InvokeMethodName: " + invokeMethodName);
            System.err.println("InvokeMethodDeclaration: " + declaration);
        }
    }
    
    public static void atLine(
            @Binding.This Object object,
            @Binding.Class Object clazz
            ,
            @Binding.Line int line,
            @Binding.Args Object[] args
            ,
            @Binding.ArgNames String[] argNames
            ,
            @Binding.LocalVars Object[] vars,
            @Binding.LocalVarNames String[] varNames
            ) {
        System.err.println("atLine: this" + object);
        System.err.println("line: " + line);
        System.err.println("args: " + Arrays.toString(args));
        System.err.println("argNames: " + Arrays.toString(argNames));
        
        System.err.println("vars: " + Arrays.toString(vars));
        System.err.println("varNames: " + Arrays.toString(varNames));
    }


    public static void main(String[] args) throws Exception {
        
        AgentUtils.install();
        // 不断执行
        final MicroService microService = new MicroService();
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < 20; ++i) {
                    try {
                        TimeUnit.SECONDS.sleep(5);
                        microService.interfaceA(String.valueOf(i));
                        System.out.println("call interfaceA result");
                    } catch (Throwable e) {
                        System.out.println("exception: " + e.getMessage());
                    }
                }
            }
        });
        thread.start();

        // 拦截器定义
//        DefaultInterceptorClassParser defaultInterceptorClassParser = new DefaultInterceptorClassParser();
//        List<InterceptorProcessor> interceptorProcessor = defaultInterceptorClassParser.parse(TestAccessInterceptor.class);
        
        
//        InterceptorProcessor lineInterceptorProcessor = new InterceptorProcessor(MicroService.class.getClassLoader());
//        InterceptorMethodConfig interceptorMethodConfig = new InterceptorMethodConfig();
//        lineInterceptorProcessor.setInterceptorMethodConfig(interceptorMethodConfig);
        
        LineLocationMatcher lineLocationMatcher = new LineLocationMatcher(33);
//        lineInterceptorProcessor.setLocationMatcher(lineLocationMatcher);
        

        // 加载字节码
        ClassNode classNode = AsmUtils.loadClass(MicroService.class);
        
        ClassNode aynLineDemoClassNode = AsmUtils.loadClass(AynLineDemo.class);
        
        InterceptorProcessor lineInterceptorProcessor  = null;
        for(Method method : AynLineDemo.class.getDeclaredMethods()) {
            if(method.getName().equals("atLine")) {
                lineInterceptorProcessor = InterceptorParserUtils.createInterceptorProcessor(method, lineLocationMatcher, false, null, null);
            }
        }
        
      
        
        // 通过拦截器对字节码增强
//        for (MethodNode methodNode : aynLineDemoClassNode.methods) {
//            if("invokeMethod".equals(methodNode.name)) {
//                interceptorMethodConfig.setInline(false);
//                interceptorMethodConfig.setMethodDesc(methodNode.desc);
//                interceptorMethodConfig.setMethodName(methodNode.name);
//                interceptorMethodConfig.setOwner(classNode.name);
//                
//                List<Binding> bindisgs = new ArrayList<Binding>();
//                bindisgs.add(new ThisBinding());
//                bindisgs.add(new LocalVarNamesBinding());
//                bindisgs.add(new LocalVarsBinding());
//                interceptorMethodConfig.setBindings(bindisgs);
//            }
//            
//        }

        // 通过拦截器对字节码增强
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode.name.equals("interfaceA")) {
                MethodProcessor methodProcessor = new MethodProcessor(classNode, methodNode);
                    lineInterceptorProcessor.process(methodProcessor);
            }
        }

        // 增强后的字节码
        byte[] bytes = AsmUtils.toBytes(classNode);

        // 查看反编译结果
        System.out.println(Decompiler.decompile(bytes));

        // 等待，查看增强前的反编译结果
        TimeUnit.SECONDS.sleep(10);

        // 增强类
        AgentUtils.reTransform(MicroService.class, bytes);
        System.in.read();
    }

}
