/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.BiFunction;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class GlobTool
implements BiFunction<String, ToolContext, String> {
    public static final String DESCRIPTION = "Find files matching a glob pattern.\n\nUsage:\n- Supports standard glob patterns: `*` (any characters), `**` (any directories), `?` (single character)\n- Returns a list of absolute file paths that match the pattern\n\nExamples:\n- `**/*.java` - Find all Java files\n- `*.txt` - Find all text files in root\n- `/src/**/*.xml` - Find all XML files under /src\n";

    @Override
    public String apply(@ToolParam(description="The glob pattern to match files") String pattern, ToolContext toolContext) {
        try {
            Path basePathObj = Paths.get(System.getProperty("user.dir"), new String[0]);
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
            ArrayList matchedFiles = new ArrayList();
            Files.walk(basePathObj, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                Path relativePath = basePathObj.relativize((Path)path);
                return matcher.matches(relativePath) || matcher.matches((Path)path);
            }).forEach(path -> matchedFiles.add(path.toString()));
            if (matchedFiles.isEmpty()) {
                return "No files found matching pattern: " + pattern;
            }
            return String.join((CharSequence)"\n", matchedFiles);
        }
        catch (IOException e) {
            return "Error searching for files: " + e.getMessage();
        }
    }

    public static ToolCallback createGlobToolCallback(String description) {
        return FunctionToolCallback.builder((String)"glob", (BiFunction)new GlobTool()).description(description).inputType(String.class).build();
    }
}

