/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class GrepTool
implements BiFunction<GrepRequest, ToolContext, String> {
    public static final String DESCRIPTION = "Search for a pattern in files.\n\nUsage:\n- The pattern parameter is the text to search for (literal string, not regex)\n- The path parameter filters which directory to search in\n- The glob parameter accepts a glob pattern to filter which files to search\n\nExamples:\n- Search all files: `grep(pattern=\"TODO\")`\n- The search is case-sensitive by default.\n";

    @Override
    public String apply(GrepRequest request, ToolContext toolContext) {
        try {
            Path searchPath = request.path != null ? Paths.get(request.path, new String[0]) : Paths.get(System.getProperty("user.dir"), new String[0]);
            ArrayList results = new ArrayList();
            PathMatcher globMatcher = request.glob != null ? FileSystems.getDefault().getPathMatcher("glob:" + request.glob) : null;
            Files.walk(searchPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> globMatcher == null || globMatcher.matches(path.getFileName())).forEach(path -> {
                try {
                    List<String> lines = Files.readAllLines(path);
                    for (int i = 0; i < lines.size(); ++i) {
                        if (!lines.get(i).contains(request.pattern)) continue;
                        Object result = switch (request.outputMode) {
                            case "files_with_matches" -> path.toString();
                            case "content" -> path + ":" + (i + 1) + ": " + lines.get(i);
                            case "count" -> path + ": matched";
                            default -> path.toString();
                        };
                        results.add(result);
                        if (!"files_with_matches".equals(request.outputMode)) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            if (results.isEmpty()) {
                return "No matches found for pattern: " + request.pattern;
            }
            return String.join((CharSequence)"\n", results);
        }
        catch (IOException e) {
            return "Error searching files: " + e.getMessage();
        }
    }

    public static ToolCallback createGrepToolCallback(String description) {
        return FunctionToolCallback.builder((String)"grep", (BiFunction)new GrepTool()).description(description).inputType(GrepRequest.class).build();
    }

    public static class GrepRequest {
        @JsonProperty(required=true)
        @JsonPropertyDescription(value="The text pattern to search for")
        public String pattern;
        @JsonProperty(value="path")
        @JsonPropertyDescription(value="The directory path to search in (default: base path)")
        public String path;
        @JsonProperty(value="glob")
        @JsonPropertyDescription(value="File pattern to filter which files to search (e.g., '*.java')")
        public String glob;
        @JsonProperty(value="output_mode")
        @JsonPropertyDescription(value="Output format: 'files_with_matches', 'content', or 'count' (default: 'files_with_matches')")
        public String outputMode = "files_with_matches";

        public GrepRequest() {
        }

        public GrepRequest(String pattern, String path, String glob, String outputMode) {
            this.pattern = pattern;
            this.path = path;
            this.glob = glob;
            this.outputMode = outputMode;
        }
    }
}

