/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent.loop;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.agent.flow.agent.loop.LoopStrategy;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.core.convert.converter.Converter;

public class ArrayLoopStrategy
implements LoopStrategy {
    private final Converter<List<Message>, List<?>> converter;
    private static final Converter<List<Message>, List<?>> DEFAULT_MESSAGE_CONVERTER = messages -> {
        String lastMessage = !messages.isEmpty() ? ((Message)messages.get(messages.size() - 1)).getText() : null;
        if (lastMessage == null) {
            return null;
        }
        return (List)JsonParser.fromJson(lastMessage, List.class);
    };

    public ArrayLoopStrategy(Converter<List<Message>, List<?>> converter) {
        this.converter = converter;
    }

    public ArrayLoopStrategy() {
        this(DEFAULT_MESSAGE_CONVERTER);
    }

    @Override
    public Map<String, Object> loopInit(OverAllState state) {
        List messages = state.value("messages").orElse(List.of());
        List list = (List)this.converter.convert(messages);
        if (list != null) {
            return Map.of(this.loopCountKey(), 0, this.loopFlagKey(), true, this.loopListKey(), list);
        }
        return Map.of(this.loopCountKey(), 0, this.loopFlagKey(), false, this.loopListKey(), List.of(), "messages", new SystemMessage("Invalid json array format"));
    }

    @Override
    public Map<String, Object> loopDispatch(OverAllState state) {
        List list = state.value(this.loopListKey(), List.class).orElse(List.of());
        int index = (Integer)state.value(this.loopCountKey(), (Object)this.maxLoopCount());
        if (index < list.size()) {
            UserMessage message = new UserMessage(list.get(index).toString());
            return Map.of(this.loopCountKey(), index + 1, this.loopFlagKey(), true, "messages", message);
        }
        return Map.of(this.loopFlagKey(), false);
    }
}

