/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.builder;

import com.alibaba.cloud.ai.graph.KeyStrategyFactory;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategyRegistry;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.model.ChatModel;

public class FlowGraphBuilder {
    public static StateGraph buildGraph(String strategyType, FlowGraphConfig config) throws GraphStateException {
        FlowGraphBuildingStrategy strategy = FlowGraphBuildingStrategyRegistry.getInstance().getStrategy(strategyType);
        strategy.validateConfig(config);
        return strategy.buildGraph(config);
    }

    public static class FlowGraphConfig {
        private String name;
        private KeyStrategyFactory keyStrategyFactory;
        private Agent rootAgent;
        private List<Agent> subAgents;
        private Map<String, Agent> conditionalAgents;
        private ChatModel chatModel;
        private Map<String, Object> customProperties = new HashMap<String, Object>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public KeyStrategyFactory getKeyStrategyFactory() {
            return this.keyStrategyFactory;
        }

        public Agent getRootAgent() {
            return this.rootAgent;
        }

        public void setRootAgent(Agent rootAgent) {
            this.rootAgent = rootAgent;
        }

        public List<Agent> getSubAgents() {
            return this.subAgents;
        }

        public void setSubAgents(List<Agent> subAgents) {
            this.subAgents = subAgents;
        }

        public Map<String, Agent> getConditionalAgents() {
            return this.conditionalAgents;
        }

        public void setConditionalAgents(Map<String, Agent> conditionalAgents) {
            this.conditionalAgents = conditionalAgents;
        }

        public ChatModel getChatModel() {
            return this.chatModel;
        }

        public void setChatModel(ChatModel chatModel) {
            this.chatModel = chatModel;
        }

        public static FlowGraphConfig builder() {
            return new FlowGraphConfig();
        }

        public FlowGraphConfig name(String name) {
            this.name = name;
            return this;
        }

        public FlowGraphConfig keyStrategyFactory(KeyStrategyFactory factory) {
            this.keyStrategyFactory = factory;
            return this;
        }

        public FlowGraphConfig rootAgent(Agent agent) {
            this.rootAgent = agent;
            return this;
        }

        public FlowGraphConfig subAgents(List<Agent> agents) {
            this.subAgents = agents;
            return this;
        }

        public FlowGraphConfig conditionalAgents(Map<String, Agent> agents) {
            this.conditionalAgents = agents;
            return this;
        }

        public FlowGraphConfig chatModel(ChatModel model) {
            this.chatModel = model;
            return this;
        }

        public FlowGraphConfig customProperty(String key, Object value) {
            this.customProperties.put(key, value);
            return this;
        }

        public Object getCustomProperty(String key) {
            return this.customProperties.get(key);
        }

        public Map<String, Object> getCustomProperties() {
            return Map.copyOf(this.customProperties);
        }
    }
}

