/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import java.util.HashMap;
import java.util.Map;

public class ParallelResultAggregator
implements NodeAction {
    private final String outputKey;

    public ParallelResultAggregator(String outputKey) {
        this.outputKey = outputKey;
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        HashMap<String, Object> updatedState = new HashMap<String, Object>();
        HashMap aggregatedResults = new HashMap();
        Map stateData = state.data();
        for (Map.Entry entry : stateData.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null || key.equals("messages")) continue;
            aggregatedResults.put(key, value);
        }
        StringBuilder combinedResult = new StringBuilder();
        combinedResult.append("Parallel execution results:\n");
        for (Map.Entry entry : aggregatedResults.entrySet()) {
            combinedResult.append("- ").append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        updatedState.put(this.outputKey, combinedResult.toString());
        return updatedState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String outputKey;

        public Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public ParallelResultAggregator build() {
            if (this.outputKey == null || this.outputKey.trim().isEmpty()) {
                throw new IllegalArgumentException("outputKey must not be null or empty");
            }
            return new ParallelResultAggregator(this.outputKey);
        }
    }
}

