/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.dashscope;

import com.alibaba.cloud.ai.autoconfigure.dashscope.ConditionalOnDashScopeEnabled;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeConnectionProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeConnectionUtils;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeVideoProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.ResolvedConnectionProperties;
import com.alibaba.cloud.ai.dashscope.api.DashScopeVideoApi;
import com.alibaba.cloud.ai.dashscope.video.DashScopeVideoModel;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnDashScopeEnabled
@ConditionalOnClass(value={DashScopeVideoApi.class})
@ConditionalOnProperty(name={"spring.ai.model.video"}, havingValue="dashscope", matchIfMissing=true)
@EnableConfigurationProperties(value={DashScopeConnectionProperties.class, DashScopeVideoProperties.class})
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class, RestClientAutoConfiguration.class})
public class DashScopeVideoAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DashScopeVideoModel dashScopeVideoModel(DashScopeConnectionProperties commonProperties, DashScopeVideoProperties videoProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        ResolvedConnectionProperties resolved = DashScopeConnectionUtils.resolveConnectionProperties(commonProperties, videoProperties, "image");
        DashScopeVideoApi videoApi = DashScopeVideoApi.builder().apiKey(resolved.apiKey()).baseUrl(resolved.baseUrl()).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable()).responseErrorHandler(responseErrorHandler).build();
        return DashScopeVideoModel.builder().videoApi(videoApi).defaultOptions(videoProperties.getOptions()).retryTemplate(retryTemplate).build();
    }
}

