/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.ChatMemoryAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.RedisChatMemoryProperties;
import com.alibaba.cloud.ai.memory.redis.RedisChatMemoryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.Jedis;

@AutoConfiguration(before={ChatMemoryAutoConfiguration.class})
@ConditionalOnClass(value={RedisChatMemoryRepository.class, Jedis.class})
@EnableConfigurationProperties(value={RedisChatMemoryProperties.class})
public class RedisChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RedisChatMemoryAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    RedisChatMemoryRepository redisChatMemoryRepository(RedisChatMemoryProperties properties) {
        logger.info("Configuring Redis chat memory repository");
        return RedisChatMemoryRepository.builder().host(properties.getHost()).port(properties.getPort()).password(properties.getPassword()).timeout(properties.getTimeout()).build();
    }
}

