/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.client;

import com.alibaba.cloud.ai.autoconfigure.mcp.client.NacosMcpSseClientAutoConfiguration;
import com.alibaba.cloud.ai.mcp.nacos.client.transport.LoadbalancedMcpAsyncClient;
import com.alibaba.cloud.ai.mcp.nacos.client.transport.LoadbalancedMcpSyncClient;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.ai.mcp.client.autoconfigure.McpClientAutoConfiguration;
import org.springframework.ai.mcp.client.autoconfigure.NamedClientMcpTransport;
import org.springframework.ai.mcp.client.autoconfigure.properties.McpClientCommonProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={NacosMcpSseClientAutoConfiguration.class, McpClientAutoConfiguration.class})
@ConditionalOnClass(value={McpSchema.class})
@EnableConfigurationProperties(value={McpClientCommonProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"nacos-enabled"}, havingValue="true", matchIfMissing=false)
public class NacosMcpClientAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<LoadbalancedMcpSyncClient> loadbalancedMcpSyncClientList(@Qualifier(value="server2NamedTransport") ObjectProvider<Map<String, List<NamedClientMcpTransport>>> server2NamedTransportProvider, ObjectProvider<NacosMcpOperationService> nacosMcpOperationServiceProvider, ApplicationContext applicationContext) {
        NacosMcpOperationService nacosMcpOperationService = (NacosMcpOperationService)nacosMcpOperationServiceProvider.getObject();
        ArrayList<LoadbalancedMcpSyncClient> loadbalancedMcpSyncClients = new ArrayList<LoadbalancedMcpSyncClient>();
        Map server2NamedTransport = (Map)server2NamedTransportProvider.getObject();
        for (Map.Entry entry : server2NamedTransport.entrySet()) {
            String serverName = (String)entry.getKey();
            LoadbalancedMcpSyncClient loadbalancedMcpSyncClient = LoadbalancedMcpSyncClient.builder().serverName(serverName).nacosMcpOperationService(nacosMcpOperationService).applicationContext(applicationContext).build();
            loadbalancedMcpSyncClient.init();
            loadbalancedMcpSyncClient.subscribe();
            loadbalancedMcpSyncClients.add(loadbalancedMcpSyncClient);
        }
        return loadbalancedMcpSyncClients;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public List<LoadbalancedMcpAsyncClient> loadbalancedMcpAsyncClientList(@Qualifier(value="server2NamedTransport") ObjectProvider<Map<String, List<NamedClientMcpTransport>>> server2NamedTransportProvider, ObjectProvider<NacosMcpOperationService> nacosMcpOperationServiceProvider, ApplicationContext applicationContext) {
        NacosMcpOperationService nacosMcpOperationService = (NacosMcpOperationService)nacosMcpOperationServiceProvider.getObject();
        ArrayList<LoadbalancedMcpAsyncClient> loadbalancedMcpAsyncClients = new ArrayList<LoadbalancedMcpAsyncClient>();
        Map server2NamedTransport = (Map)server2NamedTransportProvider.getObject();
        for (Map.Entry entry : server2NamedTransport.entrySet()) {
            String serverName = (String)entry.getKey();
            LoadbalancedMcpAsyncClient loadbalancedMcpAsyncClient = LoadbalancedMcpAsyncClient.builder().serverName(serverName).nacosMcpOperationService(nacosMcpOperationService).applicationContext(applicationContext).build();
            loadbalancedMcpAsyncClient.init();
            loadbalancedMcpAsyncClient.subscribe();
            loadbalancedMcpAsyncClients.add(loadbalancedMcpAsyncClient);
        }
        return loadbalancedMcpAsyncClients;
    }
}

