/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.client;

import com.alibaba.cloud.ai.autoconfigure.mcp.client.NacosMcpSseClientProperties;
import com.alibaba.cloud.ai.mcp.nacos.NacosMcpProperties;
import com.alibaba.cloud.ai.mcp.nacos.client.utils.NacosMcpClientUtils;
import com.alibaba.cloud.ai.mcp.nacos.registry.NacosMcpRegistryProperties;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.cloud.ai.mcp.nacos.service.model.NacosMcpServerEndpoint;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointInfo;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.utils.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.client.transport.WebFluxSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.client.autoconfigure.NamedClientMcpTransport;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration
@EnableConfigurationProperties(value={NacosMcpSseClientProperties.class, NacosMcpProperties.class, NacosMcpRegistryProperties.class})
public class NacosMcpSseClientAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(NacosMcpSseClientAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={NacosMcpOperationService.class})
    public NacosMcpOperationService nacosMcpOperationService(NacosMcpProperties nacosMcpProperties) {
        Properties nacosProperties = nacosMcpProperties.getNacosProperties();
        try {
            return new NacosMcpOperationService(nacosProperties);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean(name={"server2NamedTransport"})
    public Map<String, List<NamedClientMcpTransport>> server2NamedTransport(NacosMcpSseClientProperties nacosMcpSseClientProperties, NacosMcpOperationService nacosMcpOperationService, ObjectProvider<WebClient.Builder> webClientBuilderProvider, ObjectProvider<ObjectMapper> objectMapperProvider) {
        HashMap<String, List<NamedClientMcpTransport>> server2NamedTransport = new HashMap<String, List<NamedClientMcpTransport>>();
        WebClient.Builder webClientBuilderTemplate = (WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder);
        ObjectMapper objectMapper = (ObjectMapper)objectMapperProvider.getIfAvailable(ObjectMapper::new);
        Map<String, String> connections = nacosMcpSseClientProperties.getConnections();
        connections.forEach((serverKey, serverName) -> {
            try {
                NacosMcpServerEndpoint serverEndpoint = nacosMcpOperationService.getServerEndpoint(serverName);
                if (serverEndpoint == null) {
                    throw new NacosException(404, "can not find mcp server from nacos: " + serverName);
                }
                if (!StringUtils.equals((CharSequence)serverEndpoint.getProtocol(), (CharSequence)"mcp-sse")) {
                    throw new Exception("mcp server protocol must be sse");
                }
                ArrayList<NamedClientMcpTransport> namedTransports = new ArrayList<NamedClientMcpTransport>();
                for (McpEndpointInfo endpointInfo : serverEndpoint.getMcpEndpointInfoList()) {
                    String url = "http://" + endpointInfo.getAddress() + ":" + endpointInfo.getPort();
                    WebClient.Builder webClientBuilder = webClientBuilderTemplate.clone().baseUrl(url);
                    WebFluxSseClientTransport transport = new WebFluxSseClientTransport(webClientBuilder, objectMapper, serverEndpoint.getExportPath());
                    namedTransports.add(new NamedClientMcpTransport(serverName + "-" + NacosMcpClientUtils.getMcpEndpointInfoId((McpEndpointInfo)endpointInfo, (String)serverEndpoint.getExportPath()), (McpClientTransport)transport));
                }
                server2NamedTransport.put((String)serverName, (List<NamedClientMcpTransport>)namedTransports);
            }
            catch (Exception e) {
                logger.error("get mcp server from nacos: {} error", serverName, (Object)e);
            }
        });
        return server2NamedTransport;
    }
}

