/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.client;

import com.alibaba.cloud.ai.autoconfigure.mcp.client.NacosMcpClientAutoConfiguration;
import com.alibaba.cloud.ai.mcp.nacos.client.tool.LoadbalancedAsyncMcpToolCallbackProvider;
import com.alibaba.cloud.ai.mcp.nacos.client.tool.LoadbalancedSyncMcpToolCallbackProvider;
import com.alibaba.cloud.ai.mcp.nacos.client.transport.LoadbalancedMcpAsyncClient;
import com.alibaba.cloud.ai.mcp.nacos.client.transport.LoadbalancedMcpSyncClient;
import java.util.Collection;
import java.util.List;
import org.springframework.ai.mcp.client.autoconfigure.McpToolCallbackAutoConfiguration;
import org.springframework.ai.mcp.client.autoconfigure.properties.McpClientCommonProperties;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@AutoConfiguration(after={NacosMcpClientAutoConfiguration.class})
@EnableConfigurationProperties(value={McpClientCommonProperties.class})
@Conditional(value={McpToolCallbackAutoConfiguration.McpToolCallbackAutoConfigurationCondition.class})
public class NacosMcpToolCallbackAutoConfiguration {
    @Bean(name={"loadbalancedSyncMcpToolCallbacks"})
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public ToolCallbackProvider loadbalancedMcpToolCallbacks(ObjectProvider<List<LoadbalancedMcpSyncClient>> loadbalancedMcpSyncClients) {
        List mcpClients = loadbalancedMcpSyncClients.stream().flatMap(Collection::stream).toList();
        return new LoadbalancedSyncMcpToolCallbackProvider(mcpClients);
    }

    @Bean(name={"loadbalancedMcpAsyncToolCallbacks"})
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public ToolCallbackProvider loadbalancedMcpAsyncToolCallbacks(ObjectProvider<List<LoadbalancedMcpAsyncClient>> loadbalancedMcpAsyncClients) {
        List mcpClients = loadbalancedMcpAsyncClients.stream().flatMap(Collection::stream).toList();
        return new LoadbalancedAsyncMcpToolCallbackProvider(mcpClients);
    }
}

