/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.prompt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class PromptTmplNacosConfigCondition
implements Condition {
    private final Logger logger = LoggerFactory.getLogger(PromptTmplNacosConfigCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String tmplPrefix = "spring.ai.nacos.prompt.template.enabled";
        Boolean enabled = (Boolean)context.getEnvironment().getProperty(tmplPrefix, Boolean.class, (Object)false);
        if (!enabled.booleanValue()) {
            System.setProperty("spring.nacos.config.enabled", "false");
        }
        this.logger.debug("PromptTmplNacosConfigCondition matches enabled: {}", (Object)enabled);
        return enabled;
    }
}

