/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.spec.DashScopeAPISpec;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DashScopeAiStreamFunctionCallingHelper {
    private Boolean incrementalOutput = false;

    public DashScopeAiStreamFunctionCallingHelper() {
    }

    public DashScopeAiStreamFunctionCallingHelper(Boolean incrementalOutput) {
        this.incrementalOutput = incrementalOutput;
    }

    public DashScopeAPISpec.ChatCompletionChunk merge(DashScopeAPISpec.ChatCompletionChunk previous, DashScopeAPISpec.ChatCompletionChunk current) {
        DashScopeAPISpec.ChatCompletionOutput.Choice currentChoice0;
        DashScopeAPISpec.ChatCompletionOutput.Choice previousChoice0;
        DashScopeAPISpec.TokenUsage usage;
        if (previous == null) {
            return current;
        }
        String id = current.requestId() != null ? current.requestId() : previous.requestId();
        DashScopeAPISpec.TokenUsage tokenUsage = usage = current.usage() != null ? current.usage() : previous.usage();
        DashScopeAPISpec.ChatCompletionOutput.Choice choice = previous.output() == null ? null : (previousChoice0 = CollectionUtils.isEmpty(previous.output().choices()) ? null : previous.output().choices().get(0));
        DashScopeAPISpec.ChatCompletionOutput.Choice choice2 = current.output() == null ? null : (currentChoice0 = CollectionUtils.isEmpty(current.output().choices()) ? null : current.output().choices().get(0));
        if (!this.incrementalOutput.booleanValue() && this.isStreamingToolFunctionCall(current)) {
            if (!this.isStreamingToolFunctionCallFinish(current)) {
                return new DashScopeAPISpec.ChatCompletionChunk(id, new DashScopeAPISpec.ChatCompletionOutput(null, List.of(), null), usage, null);
            }
            List<DashScopeAPISpec.ChatCompletionOutput.Choice> choices = currentChoice0 == null ? List.of() : List.of(currentChoice0);
            return new DashScopeAPISpec.ChatCompletionChunk(id, new DashScopeAPISpec.ChatCompletionOutput(null, choices, null), usage, null);
        }
        DashScopeAPISpec.ChatCompletionOutput.Choice choice3 = this.merge(previousChoice0, currentChoice0);
        List<DashScopeAPISpec.ChatCompletionOutput.Choice> chunkChoices = choice3 == null ? List.of() : List.of(choice3);
        return new DashScopeAPISpec.ChatCompletionChunk(id, new DashScopeAPISpec.ChatCompletionOutput(null, chunkChoices, null), usage, null);
    }

    private DashScopeAPISpec.ChatCompletionOutput.Choice merge(DashScopeAPISpec.ChatCompletionOutput.Choice previous, DashScopeAPISpec.ChatCompletionOutput.Choice current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return null;
        }
        DashScopeAPISpec.ChatCompletionFinishReason finishReason = current.finishReason() != null ? current.finishReason() : previous.finishReason();
        DashScopeAPISpec.ChatCompletionMessage message = this.merge(previous.message(), current.message());
        DashScopeAPISpec.ChatCompletionLogprobs logprobs = current.logprobs() != null ? current.logprobs() : previous.logprobs();
        return new DashScopeAPISpec.ChatCompletionOutput.Choice(finishReason, message, logprobs);
    }

    private DashScopeAPISpec.ChatCompletionMessage merge(DashScopeAPISpec.ChatCompletionMessage previous, DashScopeAPISpec.ChatCompletionMessage current) {
        String content = current.content() != null ? current.content() : (previous.content() != null ? previous.content() : "");
        DashScopeAPISpec.ChatCompletionMessage.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : DashScopeAPISpec.ChatCompletionMessage.Role.ASSISTANT;
        String name = StringUtils.hasText((String)current.name()) ? current.name() : previous.name();
        String toolCallId = StringUtils.hasText((String)current.toolCallId()) ? current.toolCallId() : previous.toolCallId();
        String reasoningContent = current.reasoningContent() != null ? current.reasoningContent() : previous.reasoningContent();
        Boolean partial = current.partial() != null ? current.partial() : previous.partial();
        List<DashScopeAPISpec.ChatCompletionAnnotations> annotations = current.annotations() != null ? current.annotations() : previous.annotations();
        String status = current.status() != null ? current.status() : previous.status();
        String phase = current.phase() != null ? current.phase() : previous.phase();
        ArrayList<DashScopeAPISpec.ChatCompletionMessage.ToolCall> toolCalls = new ArrayList<DashScopeAPISpec.ChatCompletionMessage.ToolCall>();
        DashScopeAPISpec.ChatCompletionMessage.ToolCall lastPreviousTooCall = null;
        if (previous.toolCalls() != null) {
            lastPreviousTooCall = previous.toolCalls().get(previous.toolCalls().size() - 1);
            if (previous.toolCalls().size() > 1) {
                toolCalls.addAll(previous.toolCalls().subList(0, previous.toolCalls().size() - 1));
            }
        }
        if (!CollectionUtils.isEmpty(current.toolCalls())) {
            if (current.toolCalls().size() > 1) {
                throw new IllegalStateException("Currently only one tool call is supported per message!");
            }
            DashScopeAPISpec.ChatCompletionMessage.ToolCall currentToolCall = current.toolCalls().iterator().next();
            if (StringUtils.hasText((String)currentToolCall.id())) {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(currentToolCall);
            } else {
                toolCalls.add(this.merge(lastPreviousTooCall, currentToolCall));
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return new DashScopeAPISpec.ChatCompletionMessage(content, role, name, toolCallId, toolCalls, reasoningContent, partial, phase, annotations, status);
    }

    private DashScopeAPISpec.ChatCompletionMessage.ToolCall merge(DashScopeAPISpec.ChatCompletionMessage.ToolCall previous, DashScopeAPISpec.ChatCompletionMessage.ToolCall current) {
        if (previous == null) {
            return current;
        }
        String id = StringUtils.hasText((String)current.id()) ? current.id() : previous.id();
        String type = StringUtils.hasText((String)current.type()) ? current.type() : previous.type();
        Integer index = current.index() != 0 ? current.index() : previous.index();
        DashScopeAPISpec.ChatCompletionMessage.ChatCompletionFunction function = this.merge(previous.function(), current.function());
        return new DashScopeAPISpec.ChatCompletionMessage.ToolCall(id, type, function, index);
    }

    private DashScopeAPISpec.ChatCompletionMessage.ChatCompletionFunction merge(DashScopeAPISpec.ChatCompletionMessage.ChatCompletionFunction previous, DashScopeAPISpec.ChatCompletionMessage.ChatCompletionFunction current) {
        if (previous == null) {
            return current;
        }
        String name = StringUtils.hasText((String)current.name()) ? current.name() : previous.name();
        StringBuilder arguments = new StringBuilder();
        if (previous.arguments() != null) {
            arguments.append(previous.arguments());
        }
        if (current.arguments() != null) {
            arguments.append(current.arguments());
        }
        return new DashScopeAPISpec.ChatCompletionMessage.ChatCompletionFunction(name, arguments.toString());
    }

    public boolean isStreamingToolFunctionCall(DashScopeAPISpec.ChatCompletionChunk chatCompletion) {
        DashScopeAPISpec.ChatCompletionOutput.Choice choice = this.checkChatCompletionChunk(chatCompletion);
        if (choice == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(choice.message().toolCalls());
    }

    public boolean isStreamingToolFunctionCallFinish(DashScopeAPISpec.ChatCompletionChunk chatCompletion) {
        DashScopeAPISpec.ChatCompletionOutput.Choice choice = this.checkChatCompletionChunk(chatCompletion);
        if (choice == null) {
            return false;
        }
        return choice.finishReason() == DashScopeAPISpec.ChatCompletionFinishReason.TOOL_CALLS;
    }

    public DashScopeAPISpec.ChatCompletion chunkToChatCompletion(DashScopeAPISpec.ChatCompletionChunk chunk) {
        return new DashScopeAPISpec.ChatCompletion(chunk.requestId(), chunk.output(), chunk.usage());
    }

    private DashScopeAPISpec.ChatCompletionOutput.Choice checkChatCompletionChunk(DashScopeAPISpec.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || chatCompletion.output() == null || CollectionUtils.isEmpty(chatCompletion.output().choices())) {
            return null;
        }
        DashScopeAPISpec.ChatCompletionOutput.Choice choice = chatCompletion.output().choices().get(0);
        if (choice == null || choice.message() == null) {
            return null;
        }
        return choice;
    }
}

