/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.api.ApiUtils;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeAPISpec;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class DashScopeImageApi {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeImageApi.class);
    private final String baseUrl;
    private final ApiKey apiKey;
    public static final String DEFAULT_IMAGE_MODEL = DashScopeModel.ImageModel.QWEN_IMAGE.getValue();
    private final RestClient restClient;
    private final ResponseErrorHandler responseErrorHandler;

    public Builder mutate() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public DashScopeImageApi(String baseUrl, ApiKey apiKey, String workSpaceId, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.responseErrorHandler = responseErrorHandler;
        Assert.notNull((Object)apiKey, (String)"ApiKey must not be null");
        Assert.notNull((Object)baseUrl, (String)"Base URL must not be null");
        Assert.notNull((Object)restClientBuilder, (String)"RestClientBuilder must not be null");
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey.getValue(), workSpaceId)).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<DashScopeAPISpec.DashScopeImageAsyncResponse> submitImageGenTask(DashScopeAPISpec.DashScopeImageRequest request) {
        String model = request.model();
        Object url = "/api/v1/services/aigc/";
        if (model.equals(DEFAULT_IMAGE_MODEL) || model.equals(DashScopeModel.ImageModel.QWEN_IMAGE.getValue()) || model.equals(DashScopeModel.ImageModel.QWEN_IMAGE_EDIT.value)) {
            url = (String)url + "multimodal-generation/generation";
        } else if (model.equals(DashScopeModel.ImageModel.QWEN_MT_IMAGE.getValue()) || model.equals(DashScopeModel.ImageModel.WANX_2_1_IMAGEEDIT.getValue())) {
            url = (String)url + "image2image/image-synthesis";
        } else if (model.equals(DashScopeModel.ImageModel.WAN_2_2_T_2_I_PLUS.getValue()) || model.equals(DashScopeModel.ImageModel.WAN_2_2_T_2_I_FLASH.getValue()) || model.equals(DashScopeModel.ImageModel.WAN_2_5_I_2_I_PREVIEW.getValue())) {
            url = (String)url + "text2image/image-synthesis";
        } else {
            logger.info("not match model, use default url");
            url = model.contains("edit") ? (String)url + "image2image/image-synthesis" : (String)url + "text2image/image-synthesis";
            url = (String)url;
        }
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri((String)url, new Object[0])).header("X-DashScope-Async", new String[]{"enable"})).body((Object)request).retrieve().toEntity(DashScopeAPISpec.DashScopeImageAsyncResponse.class);
    }

    public ResponseEntity<DashScopeAPISpec.DashScopeImageAsyncResponse> getImageGenTaskResult(String taskId) {
        return this.restClient.get().uri("/api/v1/tasks/{task_id}", new Object[]{taskId}).retrieve().toEntity(DashScopeAPISpec.DashScopeImageAsyncResponse.class);
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    ApiKey getApiKey() {
        return this.apiKey;
    }

    RestClient getRestClient() {
        return this.restClient;
    }

    ResponseErrorHandler getResponseErrorHandler() {
        return this.responseErrorHandler;
    }

    public static class Builder {
        private String baseUrl = "https://dashscope.aliyuncs.com";
        private ApiKey apiKey;
        private String workSpaceId;
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder() {
        }

        public Builder(DashScopeImageApi api) {
            this.baseUrl = api.getBaseUrl();
            this.apiKey = api.getApiKey();
            this.restClientBuilder = api.restClient != null ? api.restClient.mutate() : RestClient.builder();
            this.responseErrorHandler = api.getResponseErrorHandler();
        }

        public Builder baseUrl(String baseUrl) {
            Assert.notNull((Object)baseUrl, (String)"Base URL cannot be null");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder workSpaceId(String workSpaceId) {
            if (StringUtils.hasText((String)workSpaceId)) {
                Assert.notNull((Object)workSpaceId, (String)"Workspace ID cannot be null");
            }
            this.workSpaceId = workSpaceId;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"Simple api key cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"Rest client builder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"Response error handler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public DashScopeImageApi build() {
            Assert.notNull((Object)this.apiKey, (String)"API key cannot be null");
            return new DashScopeImageApi(this.baseUrl, this.apiKey, this.workSpaceId, this.restClientBuilder, this.responseErrorHandler);
        }
    }
}

