/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.spec;

import com.alibaba.cloud.ai.dashscope.api.DashScopeResponseFormat;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.ModelResult;
import org.springframework.ai.model.ResultMetadata;

public class DashScopeAPISpec {
    public static final String DEFAULT_EMBEDDING_MODEL = DashScopeModel.EmbeddingModel.EMBEDDING_V2.getValue();
    public static final String DEFAULT_EMBEDDING_TEXT_TYPE = DashScopeModel.EmbeddingTextType.DOCUMENT.getValue();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DashScopeImageAsyncResponse(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="output") DashScopeImageAsyncResponseOutput output, @JsonProperty(value="usage") DashScopeImageAsyncResponseUsage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncResponseOutput(@JsonProperty(value="task_id") String taskId, @JsonProperty(value="task_status") String taskStatus, @JsonProperty(value="results") List<DashScopeImageAsyncResponseResult> results, @JsonProperty(value="task_metrics") DashScopeImageAsyncResponseTaskMetrics taskMetrics, @JsonProperty(value="code") String code, @JsonProperty(value="message") String message) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncResponseUsage(@JsonProperty(value="image_count") Integer imageCount) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncResponseResult(@JsonProperty(value="url") String url) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncResponseTaskMetrics(@JsonProperty(value="TOTAL") Integer total, @JsonProperty(value="SUCCEEDED") Integer SUCCEEDED, @JsonProperty(value="FAILED") Integer FAILED) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DashScopeImageRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") DashScopeImageRequestInput input, @JsonProperty(value="parameters") DashScopeImageRequestParameter parameters) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageRequestInput(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="negative_prompt") String negativePrompt, @JsonProperty(value="ref_img") String refImg, @JsonProperty(value="function") String function, @JsonProperty(value="base_image_url") String baseImageUrl, @JsonProperty(value="mask_image_url") String maskImageUrl, @JsonProperty(value="sketch_image_url") String sketchImageUrl) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageRequestParameter(@JsonProperty(value="style") String style, @JsonProperty(value="size") String size, @JsonProperty(value="n") Integer n, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="ref_strength") Float refStrength, @JsonProperty(value="ref_mode") String refMode, @JsonProperty(value="prompt_extend") Boolean promptExtend, @JsonProperty(value="watermark") Boolean watermark, @JsonProperty(value="sketch_weight") Integer sketchWeight, @JsonProperty(value="sketch_extraction") Boolean sketchExtraction, @JsonProperty(value="sketch_color") Integer[][] sketchColor, @JsonProperty(value="mask_color") Integer[][] maskColor) {
        }
    }

    public static enum VideoTemplate {
        SQUISH("squish"),
        POKE("poke"),
        ROTATION("rotation"),
        INFLATE("inflate"),
        DISSOLVE("dissolve"),
        CAROUSEL("carousel"),
        SINGLEHEART("singleheart"),
        DANCE1("dance1"),
        DANCE2("dance2"),
        DANCE3("dance3"),
        MERMAID("mermaid"),
        GRADUATION("graduation"),
        DEAGON("dragon"),
        MONEY("money"),
        FLYING("flying"),
        ROSE("rose"),
        CRYSTALROSE("crystalrose"),
        HUG("hug"),
        FRENCHKISS("frenchkiss"),
        COUPLEHEART("coupleheart");

        private final String value;

        private VideoTemplate(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class VideoGenerationResponse
    implements ModelResult<VideoOutput> {
        @JsonProperty(value="request_id")
        private String requestId;
        @JsonProperty(value="output")
        private VideoOutput output;
        @JsonProperty(value="usage")
        private VideoUsage usage;

        public VideoUsage getUsage() {
            return this.usage;
        }

        public void setUsage(VideoUsage usage) {
            this.usage = usage;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public VideoOutput getOutput() {
            return this.output;
        }

        public ResultMetadata getMetadata() {
            return null;
        }

        public void setOutput(VideoOutput output) {
            this.output = output;
        }

        public String toString() {
            return "VideoGenerationResponse{requestId='" + this.requestId + "', output=" + this.output + ", usage=" + this.usage + "}";
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class VideoUsage {
            @JsonProperty(value="video_duration")
            private Integer videoDuration;
            @JsonProperty(value="video_ratio")
            private String videoRatio;
            @JsonProperty(value="video_count")
            private Integer videoCount;

            public Integer getVideoDuration() {
                return this.videoDuration;
            }

            public void setVideoDuration(Integer videoDuration) {
                this.videoDuration = videoDuration;
            }

            public String getVideoRatio() {
                return this.videoRatio;
            }

            public void setVideoRatio(String videoRatio) {
                this.videoRatio = videoRatio;
            }

            public Integer getVideoCount() {
                return this.videoCount;
            }

            public void setVideoCount(Integer videoCount) {
                this.videoCount = videoCount;
            }

            public String toString() {
                return "VideoUsage{videoDuration=" + this.videoDuration + ", videoRatio='" + this.videoRatio + "', videoCount=" + this.videoCount + "}";
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class VideoOutput {
            @JsonProperty(value="task_id")
            private String taskId;
            @JsonProperty(value="task_status")
            private String taskStatus;
            @JsonProperty(value="submit_time")
            private String submitTimes;
            @JsonProperty(value="end_time")
            private String endTime;
            @JsonProperty(value="scheduled_time")
            private String scheduledTime;
            @JsonProperty(value="video_url")
            private String videoUrl;
            @JsonProperty(value="orig_prompt")
            private String origPrompt;
            @JsonProperty(value="actual_prompt")
            private String actualPrompt;
            @JsonProperty(value="code")
            private String code;
            @JsonProperty(value="message")
            private String message;

            public String getTaskId() {
                return this.taskId;
            }

            public void setTaskId(String taskId) {
                this.taskId = taskId;
            }

            public String getTaskStatus() {
                return this.taskStatus;
            }

            public void setTaskStatus(String taskStatus) {
                this.taskStatus = taskStatus;
            }

            public String getSubmitTimes() {
                return this.submitTimes;
            }

            public void setSubmitTimes(String submitTimes) {
                this.submitTimes = submitTimes;
            }

            public String getEndTime() {
                return this.endTime;
            }

            public void setEndTime(String endTime) {
                this.endTime = endTime;
            }

            public String getScheduledTime() {
                return this.scheduledTime;
            }

            public void setScheduledTime(String scheduledTime) {
                this.scheduledTime = scheduledTime;
            }

            public String getVideoUrl() {
                return this.videoUrl;
            }

            public void setVideoUrl(String videoUrl) {
                this.videoUrl = videoUrl;
            }

            public String getOrigPrompt() {
                return this.origPrompt;
            }

            public void setOrigPrompt(String origPrompt) {
                this.origPrompt = origPrompt;
            }

            public String getActualPrompt() {
                return this.actualPrompt;
            }

            public void setActualPrompt(String actualPrompt) {
                this.actualPrompt = actualPrompt;
            }

            public String getCode() {
                return this.code;
            }

            public void setCode(String code) {
                this.code = code;
            }

            public String getMessage() {
                return this.message;
            }

            public void setMessage(String message) {
                this.message = message;
            }

            public String toString() {
                return "VideoOutput{taskId='" + this.taskId + "', taskStatus='" + this.taskStatus + "', submitTimes='" + this.submitTimes + "', endTime='" + this.endTime + "', scheduledTime='" + this.scheduledTime + "', videoUrl='" + this.videoUrl + "', origPrompt='" + this.origPrompt + "', actualPrompt='" + this.actualPrompt + "', code='" + this.code + "', message='" + this.message + "'}";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class VideoGenerationRequest {
        @JsonProperty(value="model")
        private String model;
        @JsonProperty(value="input")
        private VideoInput input;
        @JsonProperty(value="parameters")
        private VideoParameters parameters;

        public VideoGenerationRequest(String model, VideoInput input, VideoParameters parameters) {
            this.model = model;
            this.input = input;
            this.parameters = parameters;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public VideoInput getInput() {
            return this.input;
        }

        public void setInput(VideoInput input) {
            this.input = input;
        }

        public VideoParameters getParameters() {
            return this.parameters;
        }

        public void setParameters(VideoParameters parameters) {
            this.parameters = parameters;
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class VideoInput {
            @JsonProperty(value="prompt")
            private String prompt;
            @JsonProperty(value="negative_prompt")
            private String negativePrompt;
            @JsonProperty(value="img_url")
            private String imageUrl;
            @JsonProperty(value="template")
            private String template;
            @JsonProperty(value="first_frame_url")
            private String firstFrameUrl;
            @JsonProperty(value="last_frame_url")
            private String lastFrameUrl;

            public VideoInput(String prompt) {
                this.prompt = prompt;
            }

            public VideoInput(String prompt, String negativePrompt) {
                this.prompt = prompt;
                this.negativePrompt = negativePrompt;
            }

            public VideoInput(String prompt, String negativePrompt, String imageUrl, String template) {
                this.prompt = prompt;
                this.negativePrompt = negativePrompt;
                this.imageUrl = imageUrl;
                this.template = template;
            }

            public VideoInput(String prompt, String negativePrompt, String imageUrl, String template, String firstFrameUrl, String lastFrameUrl) {
                this.prompt = prompt;
                this.negativePrompt = negativePrompt;
                this.imageUrl = imageUrl;
                this.template = template;
                this.firstFrameUrl = firstFrameUrl;
                this.lastFrameUrl = lastFrameUrl;
            }

            public String getFirstFrameUrl() {
                return this.firstFrameUrl;
            }

            public void setFirstFrameUrl(String firstFrameUrl) {
                this.firstFrameUrl = firstFrameUrl;
            }

            public String getLastFrameUrl() {
                return this.lastFrameUrl;
            }

            public void setLastFrameUrl(String lastFrameUrl) {
                this.lastFrameUrl = lastFrameUrl;
            }

            public String getNegativePrompt() {
                return this.negativePrompt;
            }

            public void setNegativePrompt(String negativePrompt) {
                this.negativePrompt = negativePrompt;
            }

            public String getImageUrl() {
                return this.imageUrl;
            }

            public void setImageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
            }

            public String getTemplate() {
                return this.template;
            }

            public void setTemplate(String template) {
                this.template = template;
            }

            public String getPrompt() {
                return this.prompt;
            }

            public void setPrompt(String prompt) {
                this.prompt = prompt;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String prompt;
                private String negativePrompt;
                private String imageUrl;
                private String template;
                private String firstFrameUrl;
                private String lastFrameUrl;

                public Builder prompt(String prompt) {
                    this.prompt = prompt;
                    return this;
                }

                public Builder negativePrompt(String negativePrompt) {
                    this.negativePrompt = negativePrompt;
                    return this;
                }

                public Builder imageUrl(String imageUrl) {
                    this.imageUrl = imageUrl;
                    return this;
                }

                public Builder template(VideoTemplate template) {
                    this.template = Objects.nonNull((Object)template) ? template.getValue() : "";
                    return this;
                }

                public Builder firstFrameUrl(String firstFrameUrl) {
                    this.firstFrameUrl = firstFrameUrl;
                    return this;
                }

                public Builder lastFrameUrl(String lastFrameUrl) {
                    this.lastFrameUrl = lastFrameUrl;
                    return this;
                }

                public VideoInput build() {
                    return new VideoInput(this.prompt, this.negativePrompt, this.imageUrl, this.template, this.firstFrameUrl, this.lastFrameUrl);
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class VideoParameters {
            @JsonProperty(value="resolution")
            private String resolution;
            @JsonProperty(value="size")
            private String size;
            @JsonProperty(value="duration")
            private Integer duration;
            @JsonProperty(value="seed")
            private Long seed;
            @JsonProperty(value="prompt_extend")
            private Boolean promptExtend;

            public VideoParameters(String size, Integer duration, Long seed, String resolution, Boolean promptExtend) {
                this.promptExtend = promptExtend;
                this.resolution = resolution;
                this.size = size;
                this.seed = seed;
                this.duration = duration;
            }

            public String getResolution() {
                return this.resolution;
            }

            public void setResolution(String resolution) {
                this.resolution = resolution;
            }

            public Integer getDuration() {
                return this.duration;
            }

            public void setDuration(Integer duration) {
                this.duration = duration;
            }

            public Long getSeed() {
                return this.seed;
            }

            public void setSeed(Long seed) {
                this.seed = seed;
            }

            public Boolean getPromptExtend() {
                return this.promptExtend;
            }

            public void setPromptExtend(Boolean promptExtend) {
                this.promptExtend = promptExtend;
            }

            public String getSize() {
                return this.size;
            }

            public void setSize(String size) {
                this.size = size;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String size;
                private Integer duration;
                private Long seed;
                private Boolean promptExtend;
                private String resolution;

                public Builder size(String size) {
                    this.size = size;
                    return this;
                }

                public Builder duration(Integer duration) {
                    this.duration = duration;
                    return this;
                }

                public Builder seed(Long seed) {
                    this.seed = seed;
                    return this;
                }

                public Builder promptExtend(Boolean promptExtend) {
                    this.promptExtend = promptExtend;
                    return this;
                }

                public Builder resolution(String resolution) {
                    this.resolution = resolution;
                    return this;
                }

                public VideoParameters build() {
                    return new VideoParameters(this.size, this.duration, this.seed, this.resolution, this.promptExtend);
                }
            }
        }

        public static final class Builder {
            private String model;
            private VideoInput input;
            private VideoParameters parameters;

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder input(VideoInput input) {
                this.input = input;
                return this;
            }

            public Builder parameters(VideoParameters parameters) {
                this.parameters = parameters;
                return this;
            }

            public VideoGenerationRequest build() {
                return new VideoGenerationRequest(this.model, this.input, this.parameters);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record SearchOptions(@JsonProperty(value="enable_source") Boolean enableSource, @JsonProperty(value="enable_citation") Boolean enableCitation, @JsonProperty(value="citation_format") String citationFormat, @JsonProperty(value="forced_search") Boolean forcedSearch, @JsonProperty(value="search_strategy") String searchStrategy) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Boolean enableSource;
            private Boolean enableCitation;
            private String citationFormat;
            private Boolean forcedSearch;
            private String searchStrategy;

            public Builder enableSource(Boolean enableSource) {
                this.enableSource = enableSource;
                return this;
            }

            public Builder enableCitation(Boolean enableCitation) {
                this.enableCitation = enableCitation;
                return this;
            }

            public Builder citationFormat(String citationFormat) {
                this.citationFormat = citationFormat;
                return this;
            }

            public Builder forcedSearch(Boolean forcedSearch) {
                this.forcedSearch = forcedSearch;
                return this;
            }

            public Builder searchStrategy(String searchStrategy) {
                this.searchStrategy = searchStrategy;
                return this;
            }

            public SearchOptions build() {
                return new SearchOptions(this.enableSource, this.enableCitation, this.citationFormat, this.forcedSearch, this.searchStrategy);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record RerankResponse(@JsonProperty(value="output") RerankResponseOutput output, @JsonProperty(value="usage") TokenUsage usage, @JsonProperty(value="request_id") String requestId) {
    }

    public record RerankResponseOutput(@JsonProperty(value="results") List<RerankResponseOutputResult> results) {
    }

    public record RerankResponseOutputResult(@JsonProperty(value="index") Integer index, @JsonProperty(value="relevance_score") Double relevanceScore, @JsonProperty(value="document") Map<String, Object> document) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record RerankRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") RerankRequestInput input, @JsonProperty(value="parameters") RerankRequestParameter parameters) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record RerankRequestParameter(@JsonProperty(value="top_n") Integer topN, @JsonProperty(value="return_documents") Boolean returnDocuments) {
    }

    public record RerankRequestInput(@JsonProperty(value="query") String query, @JsonProperty(value="documents") List<String> documents) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionChunk(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="output") ChatCompletionOutput output, @JsonProperty(value="usage") TokenUsage usage, Object o) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record CacheCreation(@JsonProperty(value="ephemeral_5m_input_tokens") Integer ephemeral_5m_input_tokens) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record PromptTokenDetailed(@JsonProperty(value="cached_tokens") Integer cachedTokens, @JsonProperty(value="cache_creation") CacheCreation cacheCreation, @JsonProperty(value="cache_creation_input_tokens") Integer cacheCreationInputTokens, @JsonProperty(value="cache_type") String cacheType) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OutputTokenDetailed(@JsonProperty(value="text_tokens") Integer text, @JsonProperty(value="reasoning_tokens") Integer image) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record InputTokenDetailed(@JsonProperty(value="text_tokens") Integer text, @JsonProperty(value="image_tokens") Integer image, @JsonProperty(value="audio_tokens") Integer audio) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TokenUsage(@JsonProperty(value="output_tokens") Integer outputTokens, @JsonProperty(value="input_tokens") Integer inputTokens, @JsonProperty(value="total_tokens") Integer totalTokens, @JsonProperty(value="image_tokens") Integer imageTokens, @JsonProperty(value="video_tokens") Integer videoTokens, @JsonProperty(value="audio_tokens") Integer audioTokens, @JsonProperty(value="seconds") Integer seconds, @JsonProperty(value="input_tokens_details") InputTokenDetailed inputTokensDetails, @JsonProperty(value="output_tokens_details") OutputTokenDetailed outputTokensDetails, @JsonProperty(value="prompt_tokens_details") PromptTokenDetailed promptTokenDetailed) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TopLogprobs(@JsonProperty(value="token") String token, @JsonProperty(value="bytes") byte[] bytes, @JsonProperty(value="logprob") Float logprob) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TokenInfo(@JsonProperty(value="token") String token, @JsonProperty(value="bytes") byte[] bytes, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="top_logprobs") List<TopLogprobs> topLogprobs) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionLogprobs(@JsonProperty(value="content") List<TokenInfo> content) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record SearchResult(@JsonProperty(value="site_name") String siteName, @JsonProperty(value="icon") String icon, @JsonProperty(value="index") Integer index, @JsonProperty(value="title") String title, @JsonProperty(value="url") String url) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ExtraToolInfo(@JsonProperty(value="result") String result, @JsonProperty(value="tools") String tool) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record SearchInfo(@JsonProperty(value="search_results") List<SearchResult> searchResults, @JsonProperty(value="extra_tool_info") List<ExtraToolInfo> extraToolInfo) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionOutput(@JsonProperty(value="text") String text, @JsonProperty(value="choices") List<Choice> choices, @JsonProperty(value="search_info") SearchInfo searchInfo) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Choice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="message") ChatCompletionMessage message, @JsonProperty(value="logprobs") ChatCompletionLogprobs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletion(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="output") ChatCompletionOutput output, @JsonProperty(value="usage") TokenUsage usage) {
    }

    public static enum ChatCompletionFinishReason {
        NULL,
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        TOOL_CALL;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletionMessage(@JsonProperty(value="content") Object rawContent, @JsonProperty(value="role") Role role, @JsonProperty(value="name") String name, @JsonProperty(value="tool_call_id") String toolCallId, @JsonProperty(value="tool_calls") List<ToolCall> toolCalls, @JsonProperty(value="reasoning_content") String reasoningContent, @JsonProperty(value="partial") Boolean partial, @JsonProperty(value="phase") String phase, @JsonProperty(value="annotations") List<ChatCompletionAnnotations> annotations, @JsonProperty(value="status") String status) {
        public ChatCompletionMessage(Object content, Role role) {
            this(content, role, null, null, null, null, null, null, null, null);
        }

        public String content() {
            if (this.rawContent == null) {
                return "";
            }
            Object object = this.rawContent;
            if (object instanceof String) {
                String text = (String)object;
                return text;
            }
            object = this.rawContent;
            if (object instanceof List) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return "";
                }
                Object object2 = list.get(0);
                if (object2 instanceof Map) {
                    Map map = (Map)object2;
                    if (map.isEmpty() || map.get("text") == null) {
                        return "";
                    }
                    return map.get("text").toString();
                }
            }
            throw new IllegalStateException("The content is not valid!");
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT,
            TOOL;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ChatCompletionFunction(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") String arguments) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ToolCall(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="function") ChatCompletionFunction function, @JsonProperty(value="index") Integer index) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record MediaContent(@JsonProperty(value="type") String type, @JsonProperty(value="text") String text, @JsonProperty(value="image") String image, @JsonProperty(value="video") List<String> video, @JsonProperty(value="audio") String audio) {
            public MediaContent(String text) {
                this("text", text, null, null);
            }

            public MediaContent(String type, String text, String image, List<String> video) {
                this(type, text, image, video, null);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Websites(@JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="url") String url, @JsonProperty(value="favicon") String favicon) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Research(@JsonProperty(value="id") Integer id, @JsonProperty(value="webSites") List<Websites> webSites, @JsonProperty(value="learningMap") Object learningMap) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Reference(@JsonProperty(value="icon") String icon, @JsonProperty(value="url") String url, @JsonProperty(value="title") String title, @JsonProperty(value="index_number") String indexNumber, @JsonProperty(value="description") String description) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DeepResearch(@JsonProperty(value="research") Research research, @JsonProperty(value="reference") Reference reference) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionExtra(@JsonProperty(value="deep_research") DeepResearch deepResearch) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionAnnotations(@JsonProperty(value="type") String type, @JsonProperty(value="language") String language, @JsonProperty(value="emotion") String emotion) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequestInput(@JsonProperty(value="messages") List<ChatCompletionMessage> messages) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TaskConfig(@JsonProperty(value="result_schema") Object resultSchema) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OCROption(@JsonProperty(value="task") String task, @JsonProperty(value="task_config") List<TaskConfig> taskConfig) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record LanguagePair(@JsonProperty(value="source") String source, @JsonProperty(value="target") String target) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TranslationOptions(@JsonProperty(value="source_lang") String sourceLang, @JsonProperty(value="target_lang") String targetLang, @JsonProperty(value="terms") List<LanguagePair> terms, @JsonProperty(value="tm_list") List<LanguagePair> tmList, @JsonProperty(value="domains") String domains) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequestParameter(@JsonProperty(value="result_format") String resultFormat, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="top_k") Integer topK, @JsonProperty(value="repetition_penalty") Double repetitionPenalty, @JsonProperty(value="presence_penalty") Double presencePenalty, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="stop") List<Object> stop, @JsonProperty(value="enable_search") Boolean enableSearch, @JsonProperty(value="search_options") SearchOptions searchOptions, @JsonProperty(value="response_format") DashScopeResponseFormat responseFormat, @JsonProperty(value="incremental_output") Boolean incrementalOutput, @JsonProperty(value="tools") List<FunctionTool> tools, @JsonProperty(value="tool_choice") Object toolChoice, @JsonProperty(value="parallel_tool_calls") Boolean parallelToolCalls, @JsonProperty(value="enable_thinking") Boolean enableThinking, @JsonProperty(value="thinking_budget") Integer thinkingBudget, @JsonProperty(value="vl_high_resolution_images") Boolean vlHighResolutionImages, @JsonProperty(value="vl_enable_image_hw_output") Boolean vlEnableImageHwOutput, @JsonProperty(value="ocr_options") OCROption ocrOptions, @JsonProperty(value="logprobs") Boolean logprobs, @JsonProperty(value="top_logprobs") Integer topLogprobs, @JsonProperty(value="translation_options") TranslationOptions translationOptions, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="stream_options") Object streamOptions, @JsonProperty(value="modalities") List<String> modalities, @JsonProperty(value="audio") Object audio, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="max_input_tokens") Integer maxInputTokens, @JsonProperty(value="asr_options") Object asrOptions, @JsonProperty(value="output_format") String outputFormat) {
        public ChatCompletionRequestParameter() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        public static class ToolChoiceBuilder {
            public static final String AUTO = "auto";
            public static final String NONE = "none";

            public static Object function(String functionName) {
                return Map.of("type", "function", "function", Map.of("name", functionName));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") ChatCompletionRequestInput input, @JsonProperty(value="parameters") ChatCompletionRequestParameter parameters, @JsonProperty(value="stream") Boolean stream, @JsonIgnore Boolean multiModel) {
        public ChatCompletionRequest(String model, ChatCompletionRequestInput input, Boolean stream) {
            this(model, input, null, stream, false);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record FunctionTool(@JsonProperty(value="type") Type type, @JsonProperty(value="function") Function function) {
        public FunctionTool(Function function) {
            this(Type.FUNCTION, function);
        }

        public static enum Type {
            FUNCTION;

        }

        public record Function(@JsonProperty(value="description") String description, @JsonProperty(value="name") String name, @JsonProperty(value="parameters") Map<String, Object> parameters) {
            public Function(String description, String name, String jsonSchema) {
                this(description, name, ModelOptionsUtils.jsonToMap((String)jsonSchema));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentRetrieveResponse(@JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code, @JsonProperty(value="request_id") String requestId, @JsonProperty(value="total") int total, @JsonProperty(value="nodes") List<DocumentRetrieveResponseNode> nodes) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentRetrieveResponseNodeMetaData(@JsonProperty(value="parent") String text, @JsonProperty(value="image_url") List<String> images, @JsonProperty(value="title") String title, @JsonProperty(value="doc_id") String documentId, @JsonProperty(value="doc_name") String docName, @JsonProperty(value="hier_title") String hierTitle) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentRetrieveResponseNodeData(@JsonProperty(value="id_") String id, @JsonProperty(value="text") String text, @JsonProperty(value="metadata") Map<String, Object> metadata) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentRetrieveResponseNode(@JsonProperty(value="score") double score, @JsonProperty(value="node") DocumentRetrieveResponseNodeData node) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentRetrieveRequest(@JsonProperty(value="query") String query, @JsonProperty(value="dense_similarity_top_k") int denseSimilarityTopK, @JsonProperty(value="sparse_similarity_top_k") int sparseSimilarityTopK, @JsonProperty(value="enable_rewrite") boolean enableRewrite, @JsonProperty(value="rewrite") List<DocumentRetrieveModelConfig> rewrite, @JsonProperty(value="enable_reranking") boolean enableReranking, @JsonProperty(value="rerank") List<DocumentRetrieveModelConfig> rerank, @JsonProperty(value="rerank_min_score") float rerankMinScore, @JsonProperty(value="rerank_top_n") int rerankTopN, @JsonProperty(value="search_filters") List<Map<String, Object>> searchFilters) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentRetrieveModelConfig(@JsonProperty(value="model_name") String modelName, @JsonProperty(value="class_name") String className) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DelePipelineDocumentResponse(@JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DelePipelineDocumentRequest(@JsonProperty(value="data_sources") List<DelePipelineDocumentDataSource> dataSources) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DelePipelineDocumentDataSourceComponent(@JsonProperty(value="doc_ids") List<String> docIds) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DelePipelineDocumentDataSource(@JsonProperty(value="source_type") String sourceType, @JsonProperty(value="component") List<DelePipelineDocumentDataSourceComponent> component) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record QueryPipelineResponse(@JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code, @JsonProperty(value="id") String pipelineId) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record StartPipelineResponse(@JsonProperty(value="ingestionId") String ingestionId, @JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code, @JsonProperty(value="request_id") String requestId) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UpsertPipelineResponse(@JsonProperty(value="id") String id, @JsonProperty(value="pipline_name") String pipline_name, @JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record RetrieverConfiguredTransformations(@JsonProperty(value="configurable_transformation_type") String transformationType, @JsonProperty(value="component") RetrieverComponent component) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record RetrieverComponent(@JsonProperty(value="enable_rewrite") boolean enableRewrite, @JsonProperty(value="rewrite") List<CommonModelComponent> rewriteComponents, @JsonProperty(value="sparse_similarity_top_k") int sparseSimilarityTopK, @JsonProperty(value="dense_similarity_top_k") int denseSimilarityTopK, @JsonProperty(value="enable_reranking") boolean enableRerank, @JsonProperty(value="rerank") List<CommonModelComponent> rerankComponents, @JsonProperty(value="rerank_min_score") float rerankMinScore, @JsonProperty(value="rerank_top_n") int rerankTopN, @JsonProperty(value="search_filters") List<Map<String, Object>> searchFilters) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record CommonModelComponent(@JsonProperty(value="model_name") String modelName) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingConfiguredTransformations(@JsonProperty(value="configurable_transformation_type") String transformationType, @JsonProperty(value="component") EmbeddingComponent component) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record EmbeddingComponent(@JsonProperty(value="model_name") String modelName) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ParserConfiguredTransformations(@JsonProperty(value="configurable_transformation_type") String transformationType, @JsonProperty(value="component") ParserComponent component) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ParserComponent(@JsonProperty(value="chunk_size") Integer chunkSize, @JsonProperty(value="overlap_size") Integer overlapSize, @JsonProperty(value="input_type") String inputType, @JsonProperty(value="separator") String separator, @JsonProperty(value="language") String language) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DataSourcesConfig(@JsonProperty(value="source_type") String sourceType, @JsonProperty(value="component") DataSourcesComponent component) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DataSourcesComponent(@JsonProperty(value="doc_ids") List<String> docIds) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DataSinksConfig(@JsonProperty(value="sink_type") String sinkType, @JsonProperty(value="component") DataSinksComponent component) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DataSinksComponent() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UpsertPipelineRequest(@JsonProperty(value="name") String name, @JsonProperty(value="pipeline_type") String pipelineType, @JsonProperty(value="pipeline_description") String pipelineDescription, @JsonProperty(value="data_type") String dataType, @JsonProperty(value="config_model") String configModel, @JsonProperty(value="configured_transformations") List transformations, @JsonProperty(value="data_sources") List<DataSourcesConfig> dataSources, @JsonProperty(value="data_sinks") List<DataSinksConfig> dataSinks) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentChunk(@JsonProperty(value="chunk_id") int chunkId, @JsonProperty(value="content") String content, @JsonProperty(value="title") String title, @JsonProperty(value="hier_title") String hierTitle, @JsonProperty(value="nid") String nid, @JsonProperty(value="parent") String parent) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentSplitResponseData(@JsonProperty(value="chunkResult") List<DocumentChunk> chunkResult) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentSplitResponse(@JsonProperty(value="chunkService") DocumentSplitResponseData chunkService) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentSplitRequest(@JsonProperty(value="text") String text, @JsonProperty(value="chunk_size") Integer chunkSize, @JsonProperty(value="overlap_size") Integer overlapSize, @JsonProperty(value="file_type") String fileType, @JsonProperty(value="language") String language, @JsonProperty(value="separator") String separator) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DownloadFileParam(@JsonProperty(value="method") String method, @JsonProperty(value="url") String url, @JsonProperty(value="headers") Map<String, String> headers) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record QueryFileParseResultData(@JsonProperty(value="file_id") String fileId, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="lease_id") String leaseId, @JsonProperty(value="type") String type, @JsonProperty(value="param") DownloadFileParam param) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record QueryFileResponseData(@JsonProperty(value="category") String category, @JsonProperty(value="file_id") String fileId, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="file_type") String fileType, @JsonProperty(value="size_bytes") Long sizeBytes, @JsonProperty(value="status") String status, @JsonProperty(value="upload_time") String uploadtime) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record AddFileResponseData(@JsonProperty(value="file_id") String fileId, @JsonProperty(value="parser") String method) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UploadLeaseParamData(@JsonProperty(value="url") String url, @JsonProperty(value="method") String method, @JsonProperty(value="headers") Map<String, String> header) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UploadLeaseResponseData(@JsonProperty(value="lease_id") String leaseId, @JsonProperty(value="type") String type, @JsonProperty(value="param") UploadLeaseParamData param) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UploadLeaseResponse(@JsonProperty(value="code") String code, @JsonProperty(value="message") String message, @JsonProperty(value="data") UploadLeaseResponseData data) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UploadRequest(@JsonProperty(value="category_id") String categoryId, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="size_bytes") long fileLength, @JsonProperty(value="content_md5") String fileMD5) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record QueryFileRequest(@JsonProperty(value="file_id") String fileId) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record AddFileRequest(@JsonProperty(value="lease_id") String leaseId, @JsonProperty(value="parser") String parser) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") EmbeddingRequestInput input, @JsonProperty(value="parameters") EmbeddingRequestInputParameters parameters) {
        @Deprecated
        public EmbeddingRequest(String text) {
            this(DEFAULT_EMBEDDING_MODEL, new EmbeddingRequestInput(List.of(text)), new EmbeddingRequestInputParameters(DEFAULT_EMBEDDING_TEXT_TYPE));
        }

        @Deprecated
        public EmbeddingRequest(String text, String model) {
            this(model, new EmbeddingRequestInput(List.of(text)), new EmbeddingRequestInputParameters(DEFAULT_EMBEDDING_TEXT_TYPE));
        }

        @Deprecated
        public EmbeddingRequest(String text, String model, String textType) {
            this(model, new EmbeddingRequestInput(List.of(text)), new EmbeddingRequestInputParameters(textType == null ? DEFAULT_EMBEDDING_TEXT_TYPE : textType));
        }

        @Deprecated
        public EmbeddingRequest(List<String> texts) {
            this(DEFAULT_EMBEDDING_MODEL, new EmbeddingRequestInput(texts), new EmbeddingRequestInputParameters(DEFAULT_EMBEDDING_TEXT_TYPE));
        }

        @Deprecated
        public EmbeddingRequest(List<String> texts, String model) {
            this(model, new EmbeddingRequestInput(texts), new EmbeddingRequestInputParameters(DEFAULT_EMBEDDING_TEXT_TYPE));
        }

        @Deprecated
        public EmbeddingRequest(List<String> texts, String model, String textType) {
            this(model, new EmbeddingRequestInput(texts), new EmbeddingRequestInputParameters(textType == null ? DEFAULT_EMBEDDING_TEXT_TYPE : textType));
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final List<String> texts = new ArrayList<String>();
            private String model = DEFAULT_EMBEDDING_MODEL;
            private String textType;
            private Integer dimension;

            private Builder() {
            }

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder texts(String ... texts) {
                this.texts.addAll(List.of(texts));
                return this;
            }

            public Builder texts(List<String> texts) {
                this.texts.addAll(texts);
                return this;
            }

            public Builder textType(String textType) {
                this.textType = textType;
                return this;
            }

            public Builder dimension(Integer dimension) {
                this.dimension = dimension;
                return this;
            }

            public EmbeddingRequest build() {
                return new EmbeddingRequest(this.model, new EmbeddingRequestInput(this.texts), EmbeddingRequestInputParameters.builder().textType(this.textType).dimension(this.dimension).build());
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequestInputParameters(@JsonProperty(value="text_type") String textType, @JsonProperty(value="dimension") Integer dimension) {
        @Deprecated
        public EmbeddingRequestInputParameters(String textType) {
            this(textType == null ? DEFAULT_EMBEDDING_TEXT_TYPE : textType, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String textType;
            private Integer dimension;

            private Builder() {
            }

            public Builder textType(String textType) {
                this.textType = textType;
                return this;
            }

            public Builder dimension(Integer dimension) {
                this.dimension = dimension;
                return this;
            }

            public EmbeddingRequestInputParameters build() {
                String finalTextType = this.textType == null ? DEFAULT_EMBEDDING_TEXT_TYPE : this.textType;
                return new EmbeddingRequestInputParameters(finalTextType, this.dimension);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequestInput(@JsonProperty(value="texts") List<String> texts) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Embeddings(@JsonProperty(value="embeddings") List<Embedding> embeddings) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record EmbeddingList(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="code") String code, @JsonProperty(value="message") String message, @JsonProperty(value="output") Embeddings output, @JsonProperty(value="usage") EmbeddingUsage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Embedding(@JsonProperty(value="text_index") Integer textIndex, @JsonProperty(value="embedding") float[] embedding) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingUsage(@JsonProperty(value="total_tokens") Long totalTokens) implements Usage
    {
        public Integer getPromptTokens() {
            return null;
        }

        public Integer getCompletionTokens() {
            return null;
        }

        public Object getNativeUsage() {
            return null;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record CommonResponse<T>(@JsonProperty(value="code") String code, @JsonProperty(value="message") String message, @JsonProperty(value="data") T data) {
    }
}

