/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.video;

import com.alibaba.cloud.ai.dashscope.api.DashScopeVideoApi;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeAPISpec;
import com.alibaba.cloud.ai.dashscope.video.DashScopeVideoOptions;
import com.alibaba.cloud.ai.dashscope.video.VideoMessage;
import com.alibaba.cloud.ai.dashscope.video.VideoModel;
import com.alibaba.cloud.ai.dashscope.video.VideoOptions;
import com.alibaba.cloud.ai.dashscope.video.VideoPrompt;
import com.alibaba.cloud.ai.dashscope.video.VideoResponse;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.retry.TransientAiException;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class DashScopeVideoModel
implements VideoModel {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeVideoModel.class);
    private final DashScopeVideoApi dashScopeVideoApi;
    private final DashScopeVideoOptions defaultOptions;
    private final RetryTemplate retryTemplate;

    public DashScopeVideoModel(DashScopeVideoApi dashScopeVideoApi, DashScopeVideoOptions defaultOptions, RetryTemplate retryTemplate) {
        Assert.notNull((Object)dashScopeVideoApi, (String)"DashScopeVideoApi must not be null");
        Assert.notNull((Object)defaultOptions, (String)"DashScopeVideoOptions must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        this.dashScopeVideoApi = dashScopeVideoApi;
        this.defaultOptions = defaultOptions;
        this.retryTemplate = retryTemplate;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public VideoResponse call(VideoPrompt prompt) {
        Assert.notNull((Object)prompt, (String)"Prompt must not be null");
        Assert.notEmpty((Collection)prompt.getInstructions(), (String)"Prompt instructions must not be empty");
        System.out.println("Video generation task submitted with prompt: " + prompt.getOptions());
        String taskId = this.submitGenTask(prompt);
        if (Objects.isNull(taskId)) {
            return new VideoResponse(null);
        }
        logger.warn("Video generation task submitted with taskId: {}", (Object)taskId);
        return (VideoResponse)this.retryTemplate.execute(context -> {
            DashScopeAPISpec.VideoGenerationResponse resp = this.getVideoTask(taskId);
            if (Objects.nonNull(resp)) {
                String status;
                logger.debug(String.valueOf(resp));
                switch (status = resp.getOutput().getTaskStatus()) {
                    case "SUCCEEDED": {
                        logger.info("Video generation task completed successfully: {}", (Object)taskId);
                        return this.toVideoResponse(resp);
                    }
                    case "FAILED": {
                        logger.error("Video generation task failed: {}", (Object)resp.getOutput());
                        return new VideoResponse(null);
                    }
                }
            }
            throw new TransientAiException("Video generation still pending, retry ...");
        });
    }

    public String submitGenTask(VideoPrompt prompt) {
        DashScopeAPISpec.VideoGenerationRequest request = this.buildDashScopeVideoRequest(prompt);
        DashScopeAPISpec.VideoGenerationResponse response = (DashScopeAPISpec.VideoGenerationResponse)this.dashScopeVideoApi.submitVideoGenTask(request).getBody();
        if (Objects.isNull(response) || Objects.isNull(response.getOutput().getTaskId())) {
            logger.warn("Failed to submit video generation task: {}", (Object)response);
            return null;
        }
        return response.getOutput().getTaskId();
    }

    private DashScopeAPISpec.VideoGenerationResponse getVideoTask(String taskId) {
        ResponseEntity<DashScopeAPISpec.VideoGenerationResponse> videoGenerationResponseResponseEntity = this.dashScopeVideoApi.queryVideoGenTask(taskId);
        if (videoGenerationResponseResponseEntity.getStatusCode().is2xxSuccessful()) {
            return (DashScopeAPISpec.VideoGenerationResponse)videoGenerationResponseResponseEntity.getBody();
        }
        logger.warn("Failed to query video task: {}", (Object)videoGenerationResponseResponseEntity.getStatusCode());
        return null;
    }

    private VideoResponse toVideoResponse(DashScopeAPISpec.VideoGenerationResponse asyncResp) {
        return new VideoResponse(asyncResp);
    }

    private DashScopeAPISpec.VideoGenerationRequest buildDashScopeVideoRequest(VideoPrompt prompt) {
        DashScopeVideoOptions options = this.toVideoOptions(prompt.getOptions());
        logger.debug("Submitting video generation task with options: {}", (Object)options);
        return DashScopeAPISpec.VideoGenerationRequest.builder().model(options.getModel()).input(DashScopeAPISpec.VideoGenerationRequest.VideoInput.builder().prompt(((VideoMessage)prompt.getInstructions().get(0)).getText()).negativePrompt(options.getNegativePrompt()).imageUrl(options.getImageUrl()).firstFrameUrl(options.getFirstFrameUrl()).lastFrameUrl(options.getLastFrameUrl()).template(options.getTemplate()).build()).parameters(DashScopeAPISpec.VideoGenerationRequest.VideoParameters.builder().duration(options.getDuration()).size(options.getSize()).seed(options.getSeed()).promptExtend(options.getPrompt()).build()).build();
    }

    private DashScopeVideoOptions toVideoOptions(VideoOptions runtimeOptions) {
        DashScopeVideoOptions currentOptions = DashScopeVideoOptions.builder().model(DashScopeVideoOptions.DEFAULT_MODEL).build();
        if (Objects.nonNull(runtimeOptions)) {
            currentOptions = (DashScopeVideoOptions)ModelOptionsUtils.copyToTarget((Object)runtimeOptions, VideoOptions.class, DashScopeVideoOptions.class);
        }
        currentOptions = (DashScopeVideoOptions)ModelOptionsUtils.merge((Object)currentOptions, (Object)this.defaultOptions, DashScopeVideoOptions.class);
        return currentOptions;
    }

    public static final class Builder {
        private DashScopeVideoApi videoApi;
        private DashScopeVideoOptions defaultOptions = DashScopeVideoOptions.builder().model(DashScopeVideoOptions.DEFAULT_MODEL).build();
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;

        private Builder() {
        }

        public Builder videoApi(DashScopeVideoApi videoApi) {
            this.videoApi = videoApi;
            return this;
        }

        public Builder defaultOptions(DashScopeVideoOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public DashScopeVideoModel build() {
            return new DashScopeVideoModel(this.videoApi, this.defaultOptions, this.retryTemplate);
        }
    }
}

