/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.video;

import com.alibaba.cloud.ai.dashscope.spec.DashScopeAPISpec;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeModel;
import com.alibaba.cloud.ai.dashscope.video.VideoOptions;
import com.fasterxml.jackson.annotation.JsonProperty;

public class DashScopeVideoOptions
implements VideoOptions {
    public static final String DEFAULT_MODEL = DashScopeModel.VideoModel.WANX2_1_T2V_TURBO.getValue();
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="img_url")
    private String imageUrl;
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="size")
    private String size;
    @JsonProperty(value="duration")
    private Integer duration = 5;
    @JsonProperty(value="prompt_extend")
    private Boolean promptExtend;
    @JsonProperty(value="resolution")
    private String resolution;
    private Long seed;
    @JsonProperty(value="negative_prompt")
    private String negativePrompt;
    @JsonProperty(value="template")
    private DashScopeAPISpec.VideoTemplate template;
    @JsonProperty(value="first_frame_url")
    private String firstFrameUrl;
    @JsonProperty(value="last_frame_url")
    private String lastFrameUrl;

    public DashScopeVideoOptions(String imageUrl, Long seed, String prompt, String firstFrameUrl, String lastFrameUrl, String resolution, String model, String size, Boolean promptExtend, String negativePrompt, DashScopeAPISpec.VideoTemplate template) {
        this.imageUrl = imageUrl;
        this.prompt = prompt;
        this.firstFrameUrl = firstFrameUrl;
        this.lastFrameUrl = lastFrameUrl;
        this.resolution = resolution;
        this.size = size;
        this.model = model;
        this.promptExtend = promptExtend;
        this.negativePrompt = negativePrompt;
        this.seed = seed;
        this.template = template;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Boolean getPrompt() {
        return this.promptExtend;
    }

    public void setPrompt(Boolean promptExtend) {
        this.promptExtend = promptExtend;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public String getNegativePrompt() {
        return this.negativePrompt;
    }

    public void setNegativePrompt(String negativePrompt) {
        this.negativePrompt = negativePrompt;
    }

    public DashScopeAPISpec.VideoTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(DashScopeAPISpec.VideoTemplate template) {
        this.template = template;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Boolean getPromptExtend() {
        return this.promptExtend;
    }

    public void setPromptExtend(Boolean promptExtend) {
        this.promptExtend = promptExtend;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getFirstFrameUrl() {
        return this.firstFrameUrl;
    }

    public void setFirstFrameUrl(String firstFrameUrl) {
        this.firstFrameUrl = firstFrameUrl;
    }

    public String getLastFrameUrl() {
        return this.lastFrameUrl;
    }

    public void setLastFrameUrl(String lastFrameUrl) {
        this.lastFrameUrl = lastFrameUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "DashScopeVideoOptions{model='" + this.model + "', imageUrl='" + this.imageUrl + "', prompt='" + this.prompt + "', size='" + this.size + "', duration=" + this.duration + ", promptExtend=" + this.promptExtend + ", resolution='" + this.resolution + "', seed=" + this.seed + ", negativePrompt='" + this.negativePrompt + "', template=" + this.template + ", firstFrameUrl='" + this.firstFrameUrl + "', lastFrameUrl='" + this.lastFrameUrl + "'}";
    }

    public static class Builder {
        private String model = DEFAULT_MODEL;
        private String size = "832*480";
        private String prompt;
        private String imageUrl;
        private Integer duration = 5;
        private Boolean promptExtend = false;
        private Long seed;
        private String negativePrompt;
        private String resolution;
        private String firstFrameUrl;
        private String lastFrameUrl;
        private DashScopeAPISpec.VideoTemplate template;

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder firstFrameUrl(String firstFrameUrl) {
            this.firstFrameUrl = firstFrameUrl;
            return this;
        }

        public Builder lastFrameUrl(String lastFrameUrl) {
            this.lastFrameUrl = lastFrameUrl;
            return this;
        }

        public Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public Builder promptExtend(Boolean promptExtend) {
            this.promptExtend = promptExtend;
            return this;
        }

        public Builder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Builder negativePrompt(String negativePrompt) {
            this.negativePrompt = negativePrompt;
            return this;
        }

        public Builder template(DashScopeAPISpec.VideoTemplate template) {
            this.template = template;
            return this;
        }

        public DashScopeVideoOptions build() {
            return new DashScopeVideoOptions(this.imageUrl, this.seed, this.prompt, this.firstFrameUrl, this.lastFrameUrl, this.resolution, this.model, this.size, this.promptExtend, this.negativePrompt, this.template);
        }
    }
}

