/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.transformer.splitter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.ai.transformer.splitter.TextSplitter;

public class RecursiveCharacterTextSplitter
extends TextSplitter {
    private final int chunkSize;
    private final String[] separators;

    public RecursiveCharacterTextSplitter() {
        this(1024);
    }

    public RecursiveCharacterTextSplitter(int chunkSize) {
        this(chunkSize, null);
    }

    public RecursiveCharacterTextSplitter(int chunkSize, String[] separators) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be positive");
        }
        this.chunkSize = chunkSize;
        this.separators = Objects.requireNonNullElse(separators, new String[]{"\n\n", "\n", "\u3002", "\uff01", "\uff1f", "\uff1b", "\uff0c", " "});
    }

    public List<String> splitText(String text) {
        ArrayList<String> chunks = new ArrayList<String>();
        this.splitText(text, 0, chunks);
        return chunks;
    }

    private void splitText(String text, int separatorIndex, List<String> chunks) {
        String[] splits;
        if (text.isEmpty()) {
            return;
        }
        if (text.length() <= this.chunkSize) {
            chunks.add(text);
            return;
        }
        if (separatorIndex >= this.separators.length) {
            for (int i = 0; i < text.length(); i += this.chunkSize) {
                int end = Math.min(i + this.chunkSize, text.length());
                chunks.add(text.substring(i, end));
            }
            return;
        }
        String separator = this.separators[separatorIndex];
        if (separator.isEmpty()) {
            splits = new String[text.length()];
            for (int i = 0; i < text.length(); ++i) {
                splits[i] = String.valueOf(text.charAt(i));
            }
        } else {
            splits = text.split(separator);
        }
        for (String split : splits) {
            if (split.length() > this.chunkSize) {
                this.splitText(split, separatorIndex + 1, chunks);
                continue;
            }
            chunks.add(split);
        }
    }
}

