/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.protocol.DashScopeWebSocketClient;
import com.alibaba.cloud.ai.dashscope.protocol.DashScopeWebSocketClientOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

public class DashScopeAudioSpeechApi {
    private final DashScopeWebSocketClient webSocketClient;

    public DashScopeAudioSpeechApi(String apiKey) {
        this(apiKey, null);
    }

    public DashScopeAudioSpeechApi(String apiKey, String workSpaceId) {
        this(apiKey, workSpaceId, "wss://dashscope.aliyuncs.com/api-ws/v1/inference");
    }

    public DashScopeAudioSpeechApi(String apiKey, String workSpaceId, String websocketUrl) {
        this.webSocketClient = new DashScopeWebSocketClient(DashScopeWebSocketClientOptions.builder().withApiKey(apiKey).withWorkSpaceId(workSpaceId).withUrl(websocketUrl).build());
    }

    public Flux<ByteBuffer> streamOut(Request request) {
        try {
            String message = new ObjectMapper().writeValueAsString((Object)request);
            return this.webSocketClient.streamBinaryOut(message);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ResponseFormat {
        PCM("pcm"),
        WAV("wav"),
        MP3("mp3");

        public final String formatType;

        private ResponseFormat(String value) {
            this.formatType = value;
        }

        public String getValue() {
            return this.formatType;
        }
    }

    public static enum RequestTextType {
        PLAIN_TEXT("PlainText"),
        SSML("SSML");

        private final String value;

        private RequestTextType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Response {
        ByteBuffer audio;

        public ByteBuffer getAudio() {
            return this.audio;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Request(@JsonProperty(value="header") RequestHeader header, @JsonProperty(value="payload") RequestPayload payload) {

        public record RequestHeader(@JsonProperty(value="action") String action, @JsonProperty(value="task_id") String taskId, @JsonProperty(value="streaming") String streaming) {
        }

        public record RequestPayload(@JsonProperty(value="model") String model, @JsonProperty(value="task_group") String taskGroup, @JsonProperty(value="task") String task, @JsonProperty(value="function") String function, @JsonProperty(value="input") RequestPayloadInput input, @JsonProperty(value="parameters") RequestPayloadParameters parameters) {

            public record RequestPayloadInput(@JsonProperty(value="text") String text) {
            }

            public record RequestPayloadParameters(@JsonProperty(value="volume") Integer volume, @JsonProperty(value="text_type") String textType, @JsonProperty(value="voice") String voice, @JsonProperty(value="sample_rate") Integer sampleRate, @JsonProperty(value="rate") Float rate, @JsonProperty(value="format") String format, @JsonProperty(value="pitch") Double pitch, @JsonProperty(value="phoneme_timestamp_enabled") Boolean phonemeTimestampEnabled, @JsonProperty(value="word_timestamp_enabled") Boolean wordTimestampEnabled) {
            }
        }
    }
}

