/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.evaluation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.document.Document;
import org.springframework.ai.evaluation.EvaluationRequest;
import org.springframework.ai.evaluation.Evaluator;

public abstract class LaajEvaluator
implements Evaluator {
    private ChatClient.Builder chatClientBuilder;
    private String evaluationPromptText;
    private ObjectMapper objectMapper;

    public LaajEvaluator(ChatClient.Builder chatClientBuilder) {
        this.chatClientBuilder = chatClientBuilder;
        this.evaluationPromptText = this.getDefaultEvaluationPrompt();
    }

    public LaajEvaluator(ChatClient.Builder chatClientBuilder, String evaluationPromptText) {
        this.chatClientBuilder = chatClientBuilder;
        this.evaluationPromptText = evaluationPromptText;
    }

    public LaajEvaluator(ChatClient.Builder chatClientBuilder, ObjectMapper objectMapper) {
        this.chatClientBuilder = chatClientBuilder;
        this.objectMapper = objectMapper;
        this.evaluationPromptText = this.getDefaultEvaluationPrompt();
    }

    public LaajEvaluator(ChatClient.Builder chatClientBuilder, String evaluationPromptText, ObjectMapper objectMapper) {
        this.chatClientBuilder = chatClientBuilder;
        this.objectMapper = objectMapper;
        this.evaluationPromptText = evaluationPromptText;
    }

    protected String doGetResponse(EvaluationRequest evaluationRequest) {
        return evaluationRequest.getResponseContent();
    }

    public String doGetSupportingData(EvaluationRequest evaluationRequest) {
        List data = evaluationRequest.getDataList();
        return data.stream().filter(node -> node != null && node.getText() != null).map(Document::getText).collect(Collectors.joining(System.lineSeparator()));
    }

    protected abstract String getDefaultEvaluationPrompt();

    public abstract String getName();

    public ChatClient.Builder getChatClientBuilder() {
        return this.chatClientBuilder;
    }

    public String getEvaluationPromptText() {
        return this.evaluationPromptText;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

