/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.common.tracing;

import java.lang.reflect.Method;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class McpTraceExchangeFilterFunction
implements ExchangeFilterFunction {
    private final Object tracer;

    public McpTraceExchangeFilterFunction(Object tracer) {
        this.tracer = tracer;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        if (this.tracer == null) {
            return next.exchange(request);
        }
        try {
            Object span = this.getCurrentSpan();
            if (span != null) {
                String traceId = this.getTraceId(span);
                String spanId = this.getSpanId(span);
                if (traceId != null && spanId != null) {
                    ClientRequest enrichedRequest = ClientRequest.from((ClientRequest)request).header("X-Trace-Id", new String[]{traceId}).header("X-Span-Id", new String[]{spanId}).header("X-Request-ID", new String[]{traceId}).header("traceparent", new String[]{this.buildTraceparent(traceId, spanId)}).build();
                    return next.exchange(enrichedRequest);
                }
            }
            return next.exchange(request);
        }
        catch (Exception e) {
            return next.exchange(request);
        }
    }

    private Object getCurrentSpan() {
        if (this.tracer == null) {
            return null;
        }
        try {
            Method currentSpanMethod = this.tracer.getClass().getMethod("currentSpan", new Class[0]);
            return currentSpanMethod.invoke(this.tracer, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getTraceId(Object span) {
        try {
            Method contextMethod = span.getClass().getMethod("context", new Class[0]);
            Object context = contextMethod.invoke(span, new Object[0]);
            Method traceIdMethod = context.getClass().getMethod("traceId", new Class[0]);
            return (String)traceIdMethod.invoke(context, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getSpanId(Object span) {
        try {
            Method contextMethod = span.getClass().getMethod("context", new Class[0]);
            Object context = contextMethod.invoke(span, new Object[0]);
            Method spanIdMethod = context.getClass().getMethod("spanId", new Class[0]);
            return (String)spanIdMethod.invoke(context, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String buildTraceparent(String traceId, String spanId) {
        return String.format("00-%s-%s-01", traceId, spanId);
    }
}

