/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.observation.model;

import com.alibaba.cloud.ai.observation.model.OpenTelemetrySpanBridge;
import com.alibaba.cloud.ai.observation.model.semconv.InputOutputModel;
import com.alibaba.cloud.ai.observation.model.semconv.InputOutputUtils;
import com.alibaba.cloud.ai.observation.model.semconv.MessageMode;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.tracing.handler.TracingObservationHandler;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class ChatModelInputObservationHandler
implements ObservationHandler<ChatModelObservationContext> {
    private static final Logger logger = LoggerFactory.getLogger(ChatModelInputObservationHandler.class);
    private final AttributeKey<String> inputMessagesKey;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ChatModelInputObservationHandler(MessageMode mode) {
        this.inputMessagesKey = mode == MessageMode.LANGFUSE ? AttributeKey.stringKey((String)"input.values") : AttributeKey.stringKey((String)"gen_ai.input.messages");
    }

    public void onStop(ChatModelObservationContext context) {
        String outputMessages;
        TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)context.get(TracingObservationHandler.TracingContext.class);
        Span otelSpan = OpenTelemetrySpanBridge.retrieveOtelSpan(tracingContext);
        if (otelSpan != null && (outputMessages = this.getOutputMessages(context)) != null) {
            otelSpan.setAttribute(this.inputMessagesKey, (Object)outputMessages);
        }
    }

    @Nullable
    private String getOutputMessages(ChatModelObservationContext context) {
        if (CollectionUtils.isEmpty((Collection)((Prompt)context.getRequest()).getInstructions())) {
            return null;
        }
        List<InputOutputModel.ChatMessage> messages = ((Prompt)context.getRequest()).getInstructions().stream().map(InputOutputUtils::convertFromMessage).toList();
        try {
            return this.objectMapper.writeValueAsString(messages);
        }
        catch (JsonProcessingException e) {
            logger.warn("Failed to convert output message to JSON string", (Throwable)e);
            return null;
        }
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ChatModelObservationContext;
    }
}

