/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.baidusearch;

import com.alibaba.cloud.ai.toolcalling.baidusearch.BaiduSearchProperties;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallUtils;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BaiduSearchService
implements SearchService,
Function<Request, Response> {
    private static final Logger logger = LoggerFactory.getLogger(BaiduSearchService.class);
    private final WebClientTool webClientTool;
    private final BaiduSearchProperties properties;

    public BaiduSearchService(JsonParseTool jsonParseTool, BaiduSearchProperties properties, WebClientTool webClientTool) {
        this.webClientTool = webClientTool;
        this.properties = properties;
    }

    public SearchService.Response query(String query) {
        return this.apply(new Request(query, null));
    }

    @Override
    public Response apply(Request request) {
        if (CommonToolCallUtils.isInvalidateRequestParams((Object[])new Object[]{request, request.query})) {
            return null;
        }
        return (Response)CommonToolCallUtils.handleServiceError((String)"BaiduSearch", () -> {
            int limit = request.limit == null ? this.properties.getMaxResults() : request.limit;
            String url = this.properties.getBaseUrl() + request.query;
            String html = (String)this.webClientTool.getWebClient().get().uri(url, new Object[0]).acceptCharset(new Charset[]{StandardCharsets.UTF_8}).retrieve().bodyToMono(String.class).block();
            List results = (List)CommonToolCallUtils.handleResponse((String)html, this::parseHtml, (Logger)logger);
            if (CollectionUtils.isEmpty((Collection)results)) {
                return null;
            }
            logger.info("baidu search: {},result number:{}", (Object)request.query, (Object)results.size());
            for (SearchResult d : results) {
                logger.info("{}\n{}\n{}", new Object[]{d.title(), d.abstractText(), d.sourceUrl()});
            }
            return new Response(results.subList(0, Math.min(results.size(), limit)));
        }, (Logger)logger);
    }

    private List<SearchResult> parseHtml(String htmlContent) {
        try {
            Document doc = Jsoup.parse((String)htmlContent);
            Element contentLeft = doc.selectFirst("div#content_left");
            Elements divContents = contentLeft.children();
            ArrayList<SearchResult> listData = new ArrayList<SearchResult>();
            for (Element div : divContents) {
                if (!div.hasClass("c-container")) continue;
                String title = "";
                String abstractText = "";
                String sourceUrl = div.attr("mu");
                String iconUrl = "";
                try {
                    if (div.hasClass("xpath-log") || div.hasClass("result-op")) {
                        title = div.selectFirst("h3") != null ? div.selectFirst("h3").text().trim() : div.text().trim().split("\n", 2)[0];
                        abstractText = div.selectFirst("div.c-abstract") != null ? div.selectFirst("div.c-abstract").text().trim() : (div.selectFirst("div") != null ? div.selectFirst("div").text().trim() : div.text().trim().split("\n", 2)[1].trim());
                    } else {
                        if (!"se_com_default".equals(div.attr("tpl"))) continue;
                        title = div.selectFirst("h3") != null ? div.selectFirst("h3").text().trim() : ((Element)div.children().get(0)).text().trim();
                        abstractText = div.selectFirst("div.c-abstract") != null ? div.selectFirst("div.c-abstract").text().trim() : (div.selectFirst("div") != null ? div.selectFirst("div").text().trim() : div.text().trim());
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to parse search result: {}", (Object)e.getMessage());
                    continue;
                }
                listData.add(new SearchResult(title, abstractText, sourceUrl, iconUrl));
            }
            return listData;
        }
        catch (Exception e) {
            logger.error("Failed to parse HTML content: {}", (Object)e.getMessage());
            return null;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="Baidu search API request")
    public record Request(@JsonProperty(required=true, value="query") @JsonPropertyDescription(value="The search query") String query, @JsonProperty(required=false, value="limit") @JsonPropertyDescription(value="Maximum number of results to return") Integer limit) implements SearchService.Request
    {
        public String getQuery() {
            return this.query();
        }
    }

    @JsonClassDescription(value="Baidu search API response")
    public record Response(List<SearchResult> results) implements SearchService.Response
    {
        public SearchService.SearchResult getSearchResult() {
            return new SearchService.SearchResult(this.results().stream().map(item -> new SearchService.SearchContent(item.title(), item.abstractText(), item.sourceUrl(), item.icon())).toList());
        }
    }

    public record SearchResult(String title, String abstractText, String sourceUrl, String icon) {
    }
}

