/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.tavily;

import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.tavily.ImageInfoDeserializer;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TavilySearchService
implements SearchService,
Function<Request, Response> {
    private static final Logger logger = LoggerFactory.getLogger(TavilySearchService.class);
    private final JsonParseTool jsonParseTool;
    private final WebClientTool webClientTool;

    public TavilySearchService(JsonParseTool jsonParseTool, WebClientTool webClientTool) {
        this.jsonParseTool = jsonParseTool;
        this.webClientTool = webClientTool;
    }

    public SearchService.Response query(String query) {
        return this.apply(Request.simpleQuery(query));
    }

    @Override
    public Response apply(Request request) {
        if (request == null || !StringUtils.hasText((String)request.query())) {
            return Response.errorResponse(request != null ? request.query : "", "query is empty");
        }
        try {
            String responseData = (String)this.webClientTool.post("search", (Object)request).block();
            return (Response)this.jsonParseTool.jsonToObject(responseData, (TypeReference)new TypeReference<Response>(){});
        }
        catch (Exception ex) {
            logger.error("tavily search error: {}", (Object)ex.getMessage());
            return Response.errorResponse(request.query, ex.getMessage());
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="This is the parameter entity class for TavilySearchService; values must be strictly populated according to field requirements.")
    public record Request(@JsonProperty(value="query", required=true) @JsonPropertyDescription(value="The search query to execute with Tavily.") String query, @JsonProperty(value="topic", defaultValue="general") @JsonPropertyDescription(value="The category of the search.news is useful for retrieving real-time updates, particularly about politics, sports, and major current events covered by mainstream media sources. general is for broader, more general-purpose searches that may include a wide range of sources.\nAvailable options: general, news ") String topic, @JsonProperty(value="search_depth", defaultValue="basic") @JsonPropertyDescription(value="The depth of the search. advanced search is tailored to retrieve the most relevant sources and content snippets for your query, while basic search provides generic content snippets from each source. A basic search costs 1 API Credit, while an advanced search costs 2 API Credits.\nAvailable options: basic, advanced") String searchDepth, @JsonProperty(value="chunks_per_source", defaultValue="3") @JsonPropertyDescription(value="Chunks are short content snippets (maximum 500 characters each) pulled directly from the source. Use chunks_per_source to define the maximum number of relevant chunks returned per source and to control the content length. Chunks will appear in the content field as: <chunk 1> [...] <chunk 2> [...] <chunk 3>. Available only when search_depth is advanced.\nRequired range: 1 <= x <= 3") Integer chunksPerSource, @JsonProperty(value="max_results", defaultValue="5") @JsonPropertyDescription(value="The maximum number of search results to return.\nRequired range: 0 <= x <= 20") Integer maxResults, @JsonProperty(value="time_range", defaultValue="year") @JsonPropertyDescription(value="The time range back from the current date to filter results. Useful when looking for sources that have published data.\nAvailable options: day,week, month, year, d, w, m, y ") String timeRange, @JsonProperty(value="days", defaultValue="7") @JsonPropertyDescription(value="Number of days back from the current date to include. Available only if topic is news.\nRequired range: x >= 1") Integer days, @JsonProperty(value="include_answer", defaultValue="false") @JsonPropertyDescription(value="Include an LLM-generated answer to the provided query. basic or true returns a quick answer. advanced returns a more detailed answer.") Boolean includeAnswer, @JsonProperty(value="include_raw_content", defaultValue="false") @JsonPropertyDescription(value="Include the cleaned and parsed HTML content of each search result.") Boolean includeRawContent, @JsonProperty(value="include_images", defaultValue="false") @JsonPropertyDescription(value="Also perform an image search and include the results in the response.") Boolean includeImages, @JsonProperty(value="include_image_descriptions", defaultValue="false") @JsonPropertyDescription(value="When include_images is true, also add a descriptive text for each image.") Boolean includeImageDescriptions, @JsonProperty(value="include_domains", defaultValue="[]") @JsonPropertyDescription(value="A list of domains to specifically include in the search results.") List<String> includeDomains, @JsonProperty(value="exclude_domains", defaultValue="[]") @JsonPropertyDescription(value="A list of domains to specifically exclude from the search results.") List<String> excludeDomains, @JsonProperty(value="include_favicon", defaultValue="true") @JsonPropertyDescription(value="the icon of search results.") boolean includeIcon) implements Serializable,
    SearchService.Request
    {
        public static Request simpleQuery(String query) {
            return new Request(query, null, null, null, null, null, null, null, null, null, null, null, null, true);
        }

        public String getQuery() {
            return this.query();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Response(@JsonProperty(value="query") String query, @JsonProperty(value="answer") String answer, @JsonProperty(value="images") List<ImageInfo> images, @JsonProperty(value="results") List<ResultInfo> results, @JsonProperty(value="response_time") String responseTime) implements SearchService.Response
    {
        public static Response errorResponse(String query, String errorMsg) {
            return new Response(query, errorMsg, null, null, null);
        }

        public SearchService.SearchResult getSearchResult() {
            return new SearchService.SearchResult(this.results().stream().map(item -> new SearchService.SearchContent(item.title(), item.content(), item.url(), item.icon())).toList());
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ResultInfo(@JsonProperty(value="title") String title, @JsonProperty(value="url") String url, @JsonProperty(value="content") String content, @JsonProperty(value="score") String score, @JsonProperty(value="raw_content") String raw_content, @JsonProperty(value="favicon") String icon) {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonDeserialize(using=ImageInfoDeserializer.class)
        public record ImageInfo(@JsonProperty(value="url") String url, @JsonProperty(value="description") String description) {
        }
    }
}

