/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context.edas;

import com.alibaba.cloud.context.AliCloudSdk;
import com.aliyuncs.edas.model.v20170801.GetSecureTokenRequest;
import com.aliyuncs.edas.model.v20170801.GetSecureTokenResponse;
import com.aliyuncs.edas.model.v20170801.InsertApplicationRequest;
import com.aliyuncs.edas.model.v20170801.InsertApplicationResponse;
import com.aliyuncs.exceptions.ClientException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliCloudEdasSdk {
    private static final Logger log = LoggerFactory.getLogger(AliCloudEdasSdk.class);
    private static final int SUCCESS_CODE = 200;
    private static final int DEFAULT_BUILD_PACK = -2;
    private AliCloudSdk aliCloudSdk;
    private ConcurrentHashMap<String, GetSecureTokenResponse.SecureToken> secureTokenMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, InsertApplicationResponse.ApplicationInfo> applicationInfoMap = new ConcurrentHashMap();

    public AliCloudEdasSdk(AliCloudSdk aliCloudSdk) {
        this.aliCloudSdk = aliCloudSdk;
    }

    public AliCloudSdk getAliCloudSdk() {
        return this.aliCloudSdk;
    }

    public GetSecureTokenResponse.SecureToken getSecureToken(String namespace) {
        GetSecureTokenResponse.SecureToken secureToken = this.secureTokenMap.get(namespace);
        if (secureToken == null) {
            GetSecureTokenResponse getSecureTokenResponse;
            GetSecureTokenRequest getSecureTokenRequest = new GetSecureTokenRequest();
            getSecureTokenRequest.setNamespaceId(namespace);
            try {
                getSecureTokenResponse = (GetSecureTokenResponse)this.aliCloudSdk.getAcsResponse(getSecureTokenRequest);
            }
            catch (ClientException e) {
                log.error("Get info from edas failed.", (Throwable)e);
                throw new RuntimeException(e);
            }
            if (!this.isSuccess(getSecureTokenResponse.getCode())) {
                throw new RuntimeException(null == getSecureTokenResponse.getMessage() ? "Get info from edas failed, response is null." : getSecureTokenResponse.getMessage());
            }
            this.secureTokenMap.putIfAbsent(namespace, getSecureTokenResponse.getSecureToken());
            secureToken = this.secureTokenMap.get(namespace);
        }
        return secureToken;
    }

    public InsertApplicationResponse.ApplicationInfo getApplicationInfo(String applicationName, String namespace) {
        String key = applicationName + "---" + namespace;
        InsertApplicationResponse.ApplicationInfo applicationInfo = this.applicationInfoMap.get(key);
        if (applicationInfo == null) {
            InsertApplicationResponse insertApplicationResponse;
            InsertApplicationRequest request = new InsertApplicationRequest();
            request.setApplicationName(applicationName);
            request.setLogicalRegionId(namespace);
            request.setBuildPackId(Integer.valueOf(-2));
            try {
                insertApplicationResponse = (InsertApplicationResponse)this.aliCloudSdk.getAcsResponse(request);
            }
            catch (ClientException e) {
                log.error("Register app from edas failed.", (Throwable)e);
                throw new RuntimeException(e);
            }
            if (!this.isSuccess(insertApplicationResponse.getCode())) {
                throw new RuntimeException(null == insertApplicationResponse.getMessage() ? "" : insertApplicationResponse.getMessage());
            }
            this.applicationInfoMap.putIfAbsent(key, insertApplicationResponse.getApplicationInfo());
            applicationInfo = this.applicationInfoMap.get(key);
        }
        return applicationInfo;
    }

    public boolean isSuccess(int code) {
        return code == 200;
    }
}

