/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http.matcher;

import com.alibaba.cloud.dubbo.http.matcher.AbstractHttpRequestMatcher;
import com.alibaba.cloud.dubbo.http.matcher.HeaderExpression;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.http.HttpRequest;

public class HttpRequestHeadersMatcher
extends AbstractHttpRequestMatcher {
    private final Set<HeaderExpression> expressions;

    public HttpRequestHeadersMatcher(String ... headers) {
        this.expressions = HttpRequestHeadersMatcher.parseExpressions(headers);
    }

    private static Set<HeaderExpression> parseExpressions(String ... headers) {
        LinkedHashSet<HeaderExpression> expressions = new LinkedHashSet<HeaderExpression>();
        for (String header : headers) {
            HeaderExpression expr = new HeaderExpression(header);
            if ("Accept".equalsIgnoreCase(expr.name) || "Content-Type".equalsIgnoreCase(expr.name)) continue;
            expressions.add(expr);
        }
        return expressions;
    }

    @Override
    public boolean match(HttpRequest request) {
        for (HeaderExpression expression : this.expressions) {
            if (expression.match(request)) continue;
            return false;
        }
        return true;
    }

    protected Collection<HeaderExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }
}

