/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http.matcher;

import com.alibaba.cloud.dubbo.http.matcher.AbstractHttpRequestMatcher;
import com.alibaba.cloud.dubbo.http.matcher.ParamExpression;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.http.HttpRequest;
import org.springframework.util.CollectionUtils;

public class HttpRequestParamsMatcher
extends AbstractHttpRequestMatcher {
    private final Set<ParamExpression> expressions;

    public HttpRequestParamsMatcher(String ... params) {
        this.expressions = HttpRequestParamsMatcher.parseExpressions(params);
    }

    private static Set<ParamExpression> parseExpressions(String ... params) {
        LinkedHashSet<ParamExpression> expressions = new LinkedHashSet<ParamExpression>();
        for (String param : params) {
            expressions.add(new ParamExpression(param));
        }
        return expressions;
    }

    @Override
    public boolean match(HttpRequest request) {
        if (CollectionUtils.isEmpty(this.expressions)) {
            return true;
        }
        for (ParamExpression paramExpression : this.expressions) {
            if (!paramExpression.match(request)) continue;
            return true;
        }
        return false;
    }

    protected Collection<ParamExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }
}

