/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http.matcher;

import com.alibaba.cloud.dubbo.http.matcher.AbstractHttpRequestMatcher;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class HttpRequestPathMatcher
extends AbstractHttpRequestMatcher {
    private final Set<String> patterns;
    private final PathMatcher pathMatcher;

    public HttpRequestPathMatcher(String ... patterns) {
        this.patterns = Collections.unmodifiableSet(HttpRequestPathMatcher.prependLeadingSlash(patterns));
        this.pathMatcher = new AntPathMatcher();
    }

    private static Set<String> prependLeadingSlash(String[] patterns) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(patterns.length);
        for (String pattern : patterns) {
            if (StringUtils.hasLength((String)pattern) && !pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
            result.add(pattern);
        }
        return result;
    }

    @Override
    public boolean match(HttpRequest request) {
        List<String> matches = this.getMatchingPatterns(request);
        return !matches.isEmpty();
    }

    public List<String> getMatchingPatterns(HttpRequest request) {
        String path = this.getPath(request);
        List<String> matches = this.getMatchingPatterns(path);
        return matches;
    }

    public List<String> getMatchingPatterns(String lookupPath) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String pattern : this.patterns) {
            String match = this.getMatchingPattern(pattern, lookupPath);
            if (match == null) continue;
            matches.add(match);
        }
        if (matches.size() > 1) {
            matches.sort(this.pathMatcher.getPatternComparator(lookupPath));
        }
        return matches;
    }

    private String getMatchingPattern(String pattern, String lookupPath) {
        boolean hasSuffix;
        if (pattern.equals(lookupPath)) {
            return pattern;
        }
        boolean bl = hasSuffix = pattern.indexOf(46) != -1;
        if (!hasSuffix && this.pathMatcher.match(pattern + ".*", lookupPath)) {
            return pattern + ".*";
        }
        if (this.pathMatcher.match(pattern, lookupPath)) {
            return pattern;
        }
        if (!pattern.endsWith("/") && this.pathMatcher.match(pattern + "/", lookupPath)) {
            return pattern + "/";
        }
        return null;
    }

    private String getPath(HttpRequest request) {
        URI uri = request.getURI();
        return uri.getPath();
    }

    protected Collection<String> getContent() {
        return this.patterns;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }
}

