/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.seata.feign;

import com.alibaba.cloud.seata.feign.SeataBeanPostProcessor;
import com.alibaba.cloud.seata.feign.SeataContextBeanPostProcessor;
import com.alibaba.cloud.seata.feign.SeataFeignBuilder;
import com.alibaba.cloud.seata.feign.SeataFeignObjectWrapper;
import com.alibaba.cloud.seata.feign.SeataHystrixFeignBuilder;
import com.alibaba.cloud.seata.feign.SeataSentinelFeignBuilder;
import feign.Client;
import feign.Feign;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Client.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
public class SeataFeignClientAutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnClass(name={"com.netflix.hystrix.HystrixCommand"})
    @ConditionalOnProperty(name={"feign.hystrix.enabled"}, havingValue="true")
    Feign.Builder feignHystrixBuilder(BeanFactory beanFactory) {
        return SeataHystrixFeignBuilder.builder(beanFactory);
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnClass(name={"com.alibaba.csp.sentinel.SphU"})
    @ConditionalOnProperty(name={"feign.sentinel.enabled"}, havingValue="true")
    Feign.Builder feignSentinelBuilder(BeanFactory beanFactory) {
        return SeataSentinelFeignBuilder.builder(beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    Feign.Builder feignBuilder(BeanFactory beanFactory) {
        return SeataFeignBuilder.builder(beanFactory);
    }

    @Configuration(proxyBeanMethods=false)
    protected static class FeignBeanPostProcessorConfiguration {
        protected FeignBeanPostProcessorConfiguration() {
        }

        @Bean
        SeataBeanPostProcessor seataBeanPostProcessor(SeataFeignObjectWrapper seataFeignObjectWrapper) {
            return new SeataBeanPostProcessor(seataFeignObjectWrapper);
        }

        @Bean
        SeataContextBeanPostProcessor seataContextBeanPostProcessor(BeanFactory beanFactory) {
            return new SeataContextBeanPostProcessor(beanFactory);
        }

        @Bean
        SeataFeignObjectWrapper seataFeignObjectWrapper(BeanFactory beanFactory) {
            return new SeataFeignObjectWrapper(beanFactory);
        }
    }
}

