/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.alicloud.context.ans;

import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import com.alibaba.alicloud.context.edas.EdasContextAutoConfiguration;

/**
 * @author xiaolongzuo
 */
@Configuration
@ConditionalOnClass(name = "com.alibaba.alicloud.ans.AnsAutoConfiguration")
@EnableConfigurationProperties(AnsProperties.class)
@ImportAutoConfiguration(EdasContextAutoConfiguration.class)
public class AnsContextAutoConfiguration {

}
