/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.parser.NacosByteArrayResource;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public abstract class AbstractPropertySourceLoader
implements PropertySourceLoader {
    static final String DOT = ".";

    protected boolean canLoad(String name, Resource resource) {
        return resource instanceof NacosByteArrayResource;
    }

    public List<PropertySource<?>> load(String name, Resource resource) throws IOException {
        if (!this.canLoad(name, resource)) {
            return Collections.emptyList();
        }
        return this.doLoad(name, resource);
    }

    protected abstract List<PropertySource<?>> doLoad(String var1, Resource var2) throws IOException;

    protected void flattenedMap(Map<String, Object> result, Map<String, Object> dataMap, String parentKey) {
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, Object>> entries = dataMap.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String fullKey;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = StringUtils.isEmpty((CharSequence)parentKey) ? key : (fullKey = key.startsWith("[") ? parentKey.concat(key) : parentKey.concat(DOT).concat(key));
            if (value instanceof Map) {
                Map map = (Map)value;
                this.flattenedMap(result, map, fullKey);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    this.flattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), fullKey);
                }
                continue;
            }
            result.put(fullKey, value);
        }
    }
}

