/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.registry;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import jakarta.annotation.PostConstruct;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class NacosRegistration
implements Registration,
ServiceInstance {
    public static final String MANAGEMENT_PORT = "management.port";
    public static final String MANAGEMENT_CONTEXT_PATH = "management.context-path";
    public static final String MANAGEMENT_ADDRESS = "management.address";
    public static final String MANAGEMENT_ENDPOINT_BASE_PATH = "management.endpoints.web.base-path";
    private List<NacosRegistrationCustomizer> registrationCustomizers;
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    private ApplicationContext context;

    public NacosRegistration(List<NacosRegistrationCustomizer> registrationCustomizers, NacosDiscoveryProperties nacosDiscoveryProperties, ApplicationContext context) {
        this.registrationCustomizers = registrationCustomizers;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.context = context;
    }

    @PostConstruct
    public void init() {
        Integer managementPort;
        Map<String, String> metadata = this.nacosDiscoveryProperties.getMetadata();
        Environment env = this.context.getEnvironment();
        String endpointBasePath = env.getProperty(MANAGEMENT_ENDPOINT_BASE_PATH);
        if (StringUtils.hasLength((String)endpointBasePath)) {
            metadata.put(MANAGEMENT_ENDPOINT_BASE_PATH, endpointBasePath);
        }
        if (null != (managementPort = ManagementServerPortUtils.getPort((BeanFactory)this.context))) {
            metadata.put(MANAGEMENT_PORT, managementPort.toString());
            String contextPath = env.getProperty("management.server.servlet.context-path");
            String address = env.getProperty("management.server.address");
            if (StringUtils.hasLength((String)contextPath)) {
                metadata.put(MANAGEMENT_CONTEXT_PATH, contextPath);
            }
            if (StringUtils.hasLength((String)address)) {
                metadata.put(MANAGEMENT_ADDRESS, address);
            }
        }
        if (null != this.nacosDiscoveryProperties.getHeartBeatInterval()) {
            metadata.put("preserved.heart.beat.interval", this.nacosDiscoveryProperties.getHeartBeatInterval().toString());
        }
        if (null != this.nacosDiscoveryProperties.getHeartBeatTimeout()) {
            metadata.put("preserved.heart.beat.timeout", this.nacosDiscoveryProperties.getHeartBeatTimeout().toString());
        }
        if (null != this.nacosDiscoveryProperties.getIpDeleteTimeout()) {
            metadata.put("preserved.ip.delete.timeout", this.nacosDiscoveryProperties.getIpDeleteTimeout().toString());
        }
        this.customize(this.registrationCustomizers);
    }

    protected void customize(List<NacosRegistrationCustomizer> registrationCustomizers) {
        if (registrationCustomizers != null) {
            for (NacosRegistrationCustomizer customizer : registrationCustomizers) {
                customizer.customize(this);
            }
        }
    }

    public String getServiceId() {
        return this.nacosDiscoveryProperties.getService();
    }

    public String getHost() {
        return this.nacosDiscoveryProperties.getIp();
    }

    public int getPort() {
        return this.nacosDiscoveryProperties.getPort();
    }

    public void setPort(int port) {
        this.nacosDiscoveryProperties.setPort(port);
    }

    public boolean isSecure() {
        return this.nacosDiscoveryProperties.isSecure();
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return this.nacosDiscoveryProperties.getMetadata();
    }

    public boolean isRegisterEnabled() {
        return this.nacosDiscoveryProperties.isRegisterEnabled();
    }

    public String getCluster() {
        return this.nacosDiscoveryProperties.getClusterName();
    }

    public float getRegisterWeight() {
        return this.nacosDiscoveryProperties.getWeight();
    }

    public NacosDiscoveryProperties getNacosDiscoveryProperties() {
        return this.nacosDiscoveryProperties;
    }

    public String toString() {
        return "NacosRegistration{nacosDiscoveryProperties=" + this.nacosDiscoveryProperties + "}";
    }
}

