/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class NacosDiscoveryHeartBeatPublisher
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryHeartBeatPublisher.class);
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private final ThreadPoolTaskScheduler taskScheduler;
    private final AtomicLong nacosHeartBeatIndex = new AtomicLong(0L);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private ScheduledFuture<?> heartBeatFuture;

    public NacosDiscoveryHeartBeatPublisher(NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.taskScheduler = NacosDiscoveryHeartBeatPublisher.getTaskScheduler();
    }

    private static ThreadPoolTaskScheduler getTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setBeanName("HeartBeat-Task-Scheduler");
        taskScheduler.initialize();
        return taskScheduler;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            log.info("Start nacos heartBeat task scheduler.");
            this.heartBeatFuture = this.taskScheduler.scheduleWithFixedDelay(this::publishHeartBeat, Duration.ofMillis(this.nacosDiscoveryProperties.getWatchDelay()));
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.heartBeatFuture != null) {
            this.taskScheduler.shutdown();
            this.heartBeatFuture.cancel(true);
        }
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public void publishHeartBeat() {
        HeartbeatEvent event = new HeartbeatEvent((Object)this, (Object)this.nacosHeartBeatIndex.getAndIncrement());
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

