/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http;

import com.alibaba.cloud.dubbo.http.ByteArrayHttpInputMessage;
import com.alibaba.cloud.dubbo.http.HttpServerRequest;
import com.alibaba.cloud.dubbo.http.util.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.util.MultiValueMap;

public class MutableHttpServerRequest
implements HttpServerRequest {
    private final HttpMethod httpMethod;
    private final URI uri;
    private final String path;
    private final MultiValueMap<String, String> queryParams;
    private final HttpHeaders httpHeaders;
    private final HttpInputMessage httpInputMessage;

    public MutableHttpServerRequest(HttpRequest httpRequest, byte[] body) {
        this.httpMethod = httpRequest.getMethod();
        this.uri = httpRequest.getURI();
        this.path = this.uri.getPath();
        this.httpHeaders = httpRequest.getHeaders();
        this.queryParams = HttpUtils.getParameters(httpRequest);
        this.httpInputMessage = new ByteArrayHttpInputMessage(body);
    }

    public MutableHttpServerRequest params(Map<String, String> params) {
        this.queryParams.setAll(params);
        return this;
    }

    public InputStream getBody() throws IOException {
        return this.httpInputMessage.getBody();
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public String getMethodValue() {
        return this.httpMethod.name();
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        return this.queryParams;
    }
}

