/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.dubbo.registry.event.ServiceInstancePreDeregisteredEvent;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancePreRegisteredEvent;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstanceRegisteredEvent;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

@Aspect
public class DubboServiceRegistrationEventPublishingAspect
implements ApplicationEventPublisherAware {
    public static final String REGISTER_POINTCUT_EXPRESSION = "execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.register(*)) && target(registry) && args(registration)";
    public static final String DEREGISTER_POINTCUT_EXPRESSION = "execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.deregister(*)) && target(registry) && args(registration)";
    private ApplicationEventPublisher applicationEventPublisher;

    @Before(value="execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.register(*)) && target(registry) && args(registration)", argNames="registry, registration")
    public void beforeRegister(ServiceRegistry registry, Registration registration) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ServiceInstancePreRegisteredEvent((ServiceRegistry<Registration>)registry, registration));
    }

    @Before(value="execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.deregister(*)) && target(registry) && args(registration)", argNames="registry, registration")
    public void beforeDeregister(ServiceRegistry registry, Registration registration) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ServiceInstancePreDeregisteredEvent((ServiceRegistry<Registration>)registry, registration));
    }

    @After(value="execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.register(*)) && target(registry) && args(registration)", argNames="registry, registration")
    public void afterRegister(ServiceRegistry registry, Registration registration) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ServiceInstanceRegisteredEvent(registration));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

