/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.metadata;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.compiler.support.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class ServiceInfo
implements Serializable {
    private static final long serialVersionUID = -258557978718735302L;
    private String name;
    private String group;
    private String version;
    private String protocol;
    private String path;
    private Map<String, String> params;
    private transient Map<String, String> consumerParams;
    private transient String serviceKey;
    private transient String matchKey;
    private transient URL url;
    private static final Set<String> IGNORE_KEYS = new HashSet<String>();

    public ServiceInfo(URL url) {
        this(url.getServiceInterface(), url.getParameter("group"), url.getParameter("version"), url.getProtocol(), url.getPath(), null);
        this.url = url;
        TreeMap<String, String> params = new TreeMap<String, String>();
        url.getParameters().forEach((k, v) -> {
            if (IGNORE_KEYS.contains(k)) {
                return;
            }
            params.put((String)k, (String)v);
        });
        this.params = params;
    }

    public ServiceInfo(String name, String group, String version, String protocol, String path, Map<String, String> params) {
        this.name = name;
        this.group = group;
        this.version = version;
        this.protocol = protocol;
        this.path = path;
        this.params = params == null ? new HashMap() : params;
        this.serviceKey = URL.buildKey((String)name, (String)group, (String)version);
        this.matchKey = this.buildMatchKey();
    }

    public String getMatchKey() {
        if (this.matchKey != null) {
            return this.matchKey;
        }
        this.buildMatchKey();
        return this.matchKey;
    }

    private String buildMatchKey() {
        this.matchKey = this.getServiceKey();
        if (StringUtils.isNotEmpty((String)this.protocol)) {
            this.matchKey = this.getServiceKey() + ":" + this.protocol;
        }
        return this.matchKey;
    }

    public String getServiceKey() {
        if (this.serviceKey != null) {
            return this.serviceKey;
        }
        this.serviceKey = URL.buildKey((String)this.name, (String)this.group, (String)this.version);
        return this.serviceKey;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, String> getParams() {
        if (this.params == null) {
            return Collections.emptyMap();
        }
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getParameter(String key) {
        String value;
        if (this.consumerParams != null && (value = this.consumerParams.get(key)) != null) {
            return value;
        }
        return this.params.get(key);
    }

    public String toDescString() {
        return this.getMatchKey() + this.getMethodSignaturesString() + this.getParams();
    }

    private String getMethodSignaturesString() {
        Method[] methods;
        TreeSet<String> methodStrings = new TreeSet<String>();
        for (Method method : methods = ClassUtils.forName((String)this.name).getMethods()) {
            methodStrings.add(method.toString());
        }
        return ((Object)methodStrings).toString();
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceInfo)) {
            return false;
        }
        ServiceInfo serviceInfo = (ServiceInfo)obj;
        return this.getMatchKey().equals(serviceInfo.getMatchKey()) && this.getParams().equals(serviceInfo.getParams());
    }

    public int hashCode() {
        return Objects.hash(this.getMatchKey(), this.getParams());
    }

    public String toString() {
        return "service{name='" + this.name + "',group='" + this.group + "',version='" + this.version + "',protocol='" + this.protocol + "',params=" + this.params + ",consumerParams=" + this.consumerParams + "}";
    }

    static {
        IGNORE_KEYS.add("timestamp");
        IGNORE_KEYS.add("pid");
        IGNORE_KEYS.add("interface");
        IGNORE_KEYS.add("methods");
    }
}

