/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.metadata.repository;

import com.alibaba.cloud.dubbo.env.DubboCloudProperties;
import com.alibaba.cloud.dubbo.http.DefaultHttpRequest;
import com.alibaba.cloud.dubbo.http.matcher.RequestMetadataMatcher;
import com.alibaba.cloud.dubbo.metadata.DubboRestServiceMetadata;
import com.alibaba.cloud.dubbo.metadata.RequestMetadata;
import com.alibaba.cloud.dubbo.metadata.RestMethodMetadata;
import com.alibaba.cloud.dubbo.metadata.RevisionResolver;
import com.alibaba.cloud.dubbo.metadata.ServiceInfo;
import com.alibaba.cloud.dubbo.metadata.ServiceRestMetadata;
import com.alibaba.cloud.dubbo.metadata.repository.ServiceInstanceSelector;
import com.alibaba.cloud.dubbo.registry.event.SubscribedServicesChangedEvent;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceExporter;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceProxy;
import com.alibaba.cloud.dubbo.util.DubboMetadataUtils;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpRequest;
import org.springframework.stereotype.Repository;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@Repository
public class DubboServiceMetadataRepository
implements SmartInitializingSingleton,
ApplicationEventPublisherAware {
    @Deprecated
    public static final String DUBBO_METADATA_SERVICE_PREFIX = "dubbo.metadata-service.";
    @Deprecated
    public static final String DUBBO_METADATA_SERVICE_URLS_PROPERTY_NAME = "dubbo.metadata-service.urls";
    public static String EXPORTED_SERVICES_REVISION_PROPERTY_NAME = "dubbo.metadata.revision";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Object monitor = new Object();
    private final MultiValueMap<String, URL> allExportedURLs = new LinkedMultiValueMap();
    private final Set<ServiceRestMetadata> serviceRestMetadata = new LinkedHashSet<ServiceRestMetadata>();
    private ApplicationEventPublisher applicationEventPublisher;
    private volatile Set<String> subscribedServices = Collections.emptySet();
    private final Map<String, Map<RequestMetadataMatcher, DubboRestServiceMetadata>> dubboRestServiceMetadataRepository = DubboServiceMetadataRepository.newHashMap();
    @Autowired
    private DubboCloudProperties dubboCloudProperties;
    @Autowired
    private DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private ServiceInstanceSelector serviceInstanceSelector;
    @Autowired
    private JSONUtils jsonUtils;
    @Autowired
    private InetUtils inetUtils;
    @Autowired
    private DubboMetadataUtils dubboMetadataUtils;
    @Value(value="${spring.application.name}")
    private String currentApplicationName;
    @Autowired
    private DubboMetadataServiceExporter dubboMetadataServiceExporter;

    private static <K, V> Map<K, V> getMap(Map<String, Map<K, V>> repository, String key) {
        return DubboServiceMetadataRepository.getOrDefault(repository, key, DubboServiceMetadataRepository.newHashMap());
    }

    private static <K, V> V getOrDefault(Map<K, V> source, K key, V defaultValue) {
        return (V)source.computeIfAbsent(key, k -> defaultValue);
    }

    private static <K, V> Map<K, V> newHashMap() {
        return new LinkedHashMap();
    }

    @PostConstruct
    public Stream<String> initSubscribedServices() {
        LinkedHashSet<String> newSubscribedServices = new LinkedHashSet<String>();
        if ("*".equals(this.dubboCloudProperties.getSubscribedServices())) {
            List services = this.discoveryClient.getServices();
            newSubscribedServices.addAll(services);
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Current application will subscribe all services(size:{}) in registry, a lot of memory and CPU cycles may be used, thus it's strongly recommend you using the externalized property '{}' to specify the services", (Object)newSubscribedServices.size(), (Object)"dubbo.cloud.subscribed-services");
            }
        } else {
            newSubscribedServices.addAll(this.dubboCloudProperties.subscribedServices());
        }
        this.excludeSelf(newSubscribedServices);
        Set<String> oldSubscribedServices = this.subscribedServices;
        this.subscribedServices = newSubscribedServices;
        this.dispatchEvent(new SubscribedServicesChangedEvent(this, oldSubscribedServices, newSubscribedServices));
        return newSubscribedServices.stream();
    }

    private void dispatchEvent(ApplicationEvent event) {
        this.applicationEventPublisher.publishEvent(event);
    }

    public void afterSingletonsInstantiated() {
    }

    public void initializeMetadata() {
        this.doGetSubscribedServices().forEach(this::initializeMetadata);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The metadata of Dubbo services has been initialized");
        }
    }

    public void initializeMetadata(String serviceName) {
        this.initDubboRestServiceMetadataRepository(serviceName);
    }

    private DubboMetadataService getProxy(String serviceName) {
        return this.dubboMetadataConfigServiceProxy.getProxy(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadataAndInitializedService(String serviceName, URL url) {
        Object object = this.monitor;
        synchronized (object) {
            this.dubboMetadataConfigServiceProxy.removeProxy(serviceName);
            this.dubboRestServiceMetadataRepository.remove(serviceName);
        }
    }

    public Map<String, String> getDubboMetadataServiceMetadata() {
        List<URL> dubboMetadataServiceURLs = this.dubboMetadataServiceExporter.export();
        this.removeDubboMetadataServiceURLs(dubboMetadataServiceURLs);
        Map<String, String> metadata = DubboServiceMetadataRepository.newHashMap();
        this.addDubboMetadataServiceURLsMetadata(metadata, dubboMetadataServiceURLs);
        this.addDubboProtocolsPortMetadata(metadata);
        this.addRevision(metadata);
        return Collections.unmodifiableMap(metadata);
    }

    private void addRevision(Map<String, String> metadata) {
        metadata.put(EXPORTED_SERVICES_REVISION_PROPERTY_NAME, this.calAndGetRevision());
    }

    public String calAndGetRevision() {
        if (CollectionUtils.isEmptyMap(this.allExportedURLs)) {
            return RevisionResolver.getEmptyRevision();
        }
        ArrayList descs = new ArrayList(this.allExportedURLs.size());
        for (Map.Entry entry : this.allExportedURLs.entrySet()) {
            ((List)entry.getValue()).stream().map(ServiceInfo::new).map(ServiceInfo::toDescString).forEach(descs::add);
        }
        descs.sort(String::compareTo);
        return RevisionResolver.calRevision(((Object)descs).toString());
    }

    private void removeDubboMetadataServiceURLs(List<URL> dubboMetadataServiceURLs) {
        dubboMetadataServiceURLs.stream().map(URL::getServiceKey).distinct().forEach(arg_0 -> this.allExportedURLs.remove(arg_0));
    }

    private void addDubboMetadataServiceURLsMetadata(Map<String, String> metadata, List<URL> dubboMetadataServiceURLs) {
        String dubboMetadataServiceURLsJSON = this.jsonUtils.toJSON(dubboMetadataServiceURLs);
        metadata.put(DUBBO_METADATA_SERVICE_URLS_PROPERTY_NAME, dubboMetadataServiceURLsJSON);
    }

    private void addDubboProtocolsPortMetadata(Map<String, String> metadata) {
        this.allExportedURLs.values().stream().flatMap(v -> v.stream()).forEach(url -> {
            String protocol = url.getProtocol();
            String propertyName = this.getDubboProtocolPropertyName(protocol);
            String propertyValue = String.valueOf(url.getPort());
            metadata.put(propertyName, propertyValue);
        });
    }

    public void publishServiceRestMetadata(Set<ServiceRestMetadata> serviceRestMetadataSet) {
        for (ServiceRestMetadata serviceRestMetadata : serviceRestMetadataSet) {
            if (org.springframework.util.CollectionUtils.isEmpty(serviceRestMetadata.getMeta())) continue;
            this.serviceRestMetadata.add(serviceRestMetadata);
        }
    }

    public Set<ServiceRestMetadata> getServiceRestMetadata() {
        return Collections.unmodifiableSet(this.serviceRestMetadata);
    }

    public boolean isSubscribedService(String serviceName) {
        return this.doGetSubscribedServices().contains(serviceName);
    }

    public void exportURL(URL url) {
        URL actualURL = url;
        InetUtils.HostInfo hostInfo = this.inetUtils.findFirstNonLoopbackHostInfo();
        String ipAddress = hostInfo.getIpAddress();
        if (!Objects.equals(url.getHost(), ipAddress)) {
            actualURL = url.setHost(ipAddress);
        }
        this.allExportedURLs.add((Object)actualURL.getServiceKey(), (Object)actualURL);
    }

    public void unexportURL(URL url) {
        String key = url.getServiceKey();
        List urls = (List)this.allExportedURLs.get((Object)key);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)urls)) {
            urls.remove(url);
            this.allExportedURLs.addAll((Object)key, urls);
        }
    }

    public Map<String, List<URL>> getAllExportedUrls() {
        return Collections.unmodifiableMap(this.allExportedURLs);
    }

    public Set<String> getAllServiceKeys() {
        return this.allExportedURLs.keySet();
    }

    public Integer getDubboProtocolPort(ServiceInstance serviceInstance, String protocol) {
        return this.dubboMetadataUtils.getDubboProtocolPort(serviceInstance, protocol);
    }

    private String getDubboProtocolPropertyName(String protocol) {
        return this.dubboMetadataUtils.getDubboProtocolPropertyName(protocol);
    }

    public List<URL> getExportedURLs(String serviceInterface, String group, String version) {
        if (group != null) {
            LinkedList<URL> urls = new LinkedList<URL>();
            if ("*".equals(group)) {
                String serviceKey = URL.buildKey((String)serviceInterface, (String)group, (String)version);
                String expectKey = serviceKey.substring(2);
                for (String key : this.allExportedURLs.keySet()) {
                    if (!key.endsWith(expectKey)) continue;
                    urls.addAll((Collection)this.allExportedURLs.get((Object)key));
                }
            } else {
                String[] groups;
                for (String expectKey : groups = group.split(",")) {
                    String serviceKey = URL.buildKey((String)serviceInterface, (String)expectKey, (String)version);
                    List urlList = (List)this.allExportedURLs.get((Object)serviceKey);
                    if (urlList == null) continue;
                    urls.addAll(urlList);
                }
            }
            return urls;
        }
        String serviceKey = URL.buildKey((String)serviceInterface, null, (String)version);
        return (List)this.allExportedURLs.getOrDefault((Object)serviceKey, Collections.emptyList());
    }

    protected void initDubboRestServiceMetadataRepository(String serviceName) {
        if (this.dubboRestServiceMetadataRepository.containsKey(serviceName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("The metadata of Dubbo service[name : {}] has been initialized", (Object)serviceName);
            }
            return;
        }
        Set<ServiceRestMetadata> serviceRestMetadataSet = this.getServiceRestMetadataSet(serviceName);
        if (org.springframework.util.CollectionUtils.isEmpty(serviceRestMetadataSet)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The Spring application[name : {}] does not expose The REST metadata in the Dubbo services.", (Object)serviceName);
            }
            return;
        }
        Map<RequestMetadataMatcher, DubboRestServiceMetadata> metadataMap = this.getMetadataMap(serviceName);
        for (ServiceRestMetadata serviceRestMetadata : serviceRestMetadataSet) {
            serviceRestMetadata.getMeta().forEach(restMethodMetadata -> {
                RequestMetadata requestMetadata = restMethodMetadata.getRequest();
                RequestMetadataMatcher matcher = new RequestMetadataMatcher(requestMetadata);
                DubboRestServiceMetadata metadata = new DubboRestServiceMetadata(serviceRestMetadata, (RestMethodMetadata)restMethodMetadata);
                metadataMap.put(matcher, metadata);
            });
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The REST metadata in the dubbo services has been loaded in the Spring application[name : {}]", (Object)serviceName);
        }
    }

    public DubboRestServiceMetadata get(String serviceName, RequestMetadata requestMetadata) {
        return (DubboRestServiceMetadata)this.match(this.dubboRestServiceMetadataRepository, serviceName, requestMetadata);
    }

    protected Set<String> doGetSubscribedServices() {
        Set<String> subscribedServices = this.subscribedServices;
        return subscribedServices == null ? Collections.emptySet() : subscribedServices;
    }

    public Set<String> getSubscribedServices() {
        return Collections.unmodifiableSet(this.doGetSubscribedServices());
    }

    private <T> T match(Map<String, Map<RequestMetadataMatcher, T>> repository, String serviceName, RequestMetadata requestMetadata) {
        RequestMetadataMatcher matcher;
        Map<RequestMetadataMatcher, T> map = repository.get(serviceName);
        T object = null;
        if (!org.springframework.util.CollectionUtils.isEmpty(map) && (object = (T)map.get(matcher = new RequestMetadataMatcher(requestMetadata))) == null) {
            HttpRequest request = DefaultHttpRequest.builder().method(requestMetadata.getMethod()).path(requestMetadata.getPath()).params((Map<String, List<String>>)requestMetadata.getParams()).headers(requestMetadata.getHeaders()).build();
            for (Map.Entry<RequestMetadataMatcher, T> entry : map.entrySet()) {
                RequestMetadataMatcher possibleMatcher = entry.getKey();
                if (!possibleMatcher.match(request)) continue;
                object = entry.getValue();
                break;
            }
        }
        if (object == null && this.logger.isWarnEnabled()) {
            this.logger.warn("DubboServiceMetadata can't be found in the Spring application [{}] and {}", (Object)serviceName, (Object)requestMetadata);
        }
        return object;
    }

    private Map<RequestMetadataMatcher, DubboRestServiceMetadata> getMetadataMap(String serviceName) {
        return DubboServiceMetadataRepository.getMap(this.dubboRestServiceMetadataRepository, serviceName);
    }

    private Set<ServiceRestMetadata> getServiceRestMetadataSet(String serviceName) {
        Set metadata;
        block4: {
            metadata = Collections.emptySet();
            DubboMetadataService dubboMetadataService = this.getProxy(serviceName);
            if (dubboMetadataService != null) {
                try {
                    String serviceRestMetadataJsonConfig = dubboMetadataService.getServiceRestMetadata();
                    if (StringUtils.hasText((String)serviceRestMetadataJsonConfig)) {
                        metadata = (Set)this.objectMapper.readValue(serviceRestMetadataJsonConfig, (JavaType)TypeFactory.defaultInstance().constructCollectionType(LinkedHashSet.class, ServiceRestMetadata.class));
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return metadata;
    }

    private void excludeSelf(Set<String> subscribedServices) {
        subscribedServices.remove(this.currentApplicationName);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public List<URL> findSubscribedDubboMetadataServiceURLs(URL subscribedURL) {
        String serviceInterface = subscribedURL.getServiceInterface();
        String group = subscribedURL.getParameter("group");
        String version = subscribedURL.getParameter("version");
        String protocol = subscribedURL.getParameter("protocol");
        List serviceInstances = this.discoveryClient.getInstances(group);
        List<URL> urls = this.dubboMetadataUtils.getDubboMetadataServiceURLs(serviceInstances, serviceInterface, version, protocol);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The DubboMetadataService of service [name : {} , instances : {}] URLs[protocol : {} , size : {}] has been subscribed.", new Object[]{group, serviceInstances.size(), protocol, urls.size()});
        }
        return urls;
    }
}

