/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.openfeign;

import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.openfeign.TargeterInvocationHandler;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceExecutionContextFactory;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public class TargeterBeanPostProcessor
implements BeanPostProcessor,
BeanClassLoaderAware {
    private final Environment environment;
    private final DubboServiceMetadataRepository dubboServiceMetadataRepository;
    private final DubboGenericServiceFactory dubboGenericServiceFactory;
    private final DubboGenericServiceExecutionContextFactory contextFactory;
    private ClassLoader classLoader;

    public TargeterBeanPostProcessor(Environment environment, DubboServiceMetadataRepository dubboServiceMetadataRepository, DubboGenericServiceFactory dubboGenericServiceFactory, DubboGenericServiceExecutionContextFactory contextFactory) {
        this.environment = environment;
        this.dubboServiceMetadataRepository = dubboServiceMetadataRepository;
        this.dubboGenericServiceFactory = dubboGenericServiceFactory;
        this.contextFactory = contextFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (ClassUtils.isPresent((String)"org.springframework.cloud.openfeign.Targeter", (ClassLoader)this.classLoader)) {
            Class beanClass = ClassUtils.getUserClass(bean.getClass());
            Class targetClass = ClassUtils.resolveClassName((String)"org.springframework.cloud.openfeign.Targeter", (ClassLoader)this.classLoader);
            if (targetClass.isAssignableFrom(beanClass)) {
                return Proxy.newProxyInstance(this.classLoader, new Class[]{targetClass}, (InvocationHandler)new TargeterInvocationHandler(bean, this.environment, this.classLoader, this.dubboServiceMetadataRepository, this.dubboGenericServiceFactory, this.contextFactory));
            }
        }
        return bean;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

