/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.dubbo.metadata.RevisionResolver;
import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.GenearalServiceSubscribeHandler;
import com.alibaba.cloud.dubbo.registry.MetadataServiceSubscribeHandler;
import com.alibaba.cloud.dubbo.registry.ReSubscribeManager;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancesChangedEvent;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceProxy;
import com.alibaba.cloud.dubbo.util.DubboMetadataUtils;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class DubboCloudRegistry
extends FailbackRegistry
implements ApplicationListener<ServiceInstancesChangedEvent> {
    protected static final String DUBBO_METADATA_SERVICE_CLASS_NAME = DubboMetadataService.class.getName();
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final DiscoveryClient discoveryClient;
    private final DubboServiceMetadataRepository repository;
    private final DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    private final JSONUtils jsonUtils;
    private final DubboMetadataUtils dubboMetadataUtils;
    private final ConfigurableApplicationContext applicationContext;
    private final ReSubscribeManager reSubscribeManager;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final Map<URL, GenearalServiceSubscribeHandler> urlSubscribeHandlerMap = new ConcurrentHashMap<URL, GenearalServiceSubscribeHandler>();
    private final Map<String, MetadataServiceSubscribeHandler> metadataSubscribeHandlerMap = new ConcurrentHashMap<String, MetadataServiceSubscribeHandler>();
    private final Map<String, Map<String, List<ServiceInstance>>> serviceRevisionInstanceMap = new ConcurrentHashMap<String, Map<String, List<ServiceInstance>>>();

    public DubboCloudRegistry(URL url, DiscoveryClient discoveryClient, DubboServiceMetadataRepository repository, DubboMetadataServiceProxy dubboMetadataConfigServiceProxy, JSONUtils jsonUtils, ConfigurableApplicationContext applicationContext) {
        super(url);
        this.discoveryClient = discoveryClient;
        this.repository = repository;
        this.dubboMetadataConfigServiceProxy = dubboMetadataConfigServiceProxy;
        this.jsonUtils = jsonUtils;
        this.applicationContext = applicationContext;
        this.dubboMetadataUtils = this.getBean(DubboMetadataUtils.class);
        this.reSubscribeManager = new ReSubscribeManager(this);
    }

    private void preInit() {
        if (this.inited.compareAndSet(false, true)) {
            Set<String> subscribeApps = this.getServices(null);
            for (String appName : subscribeApps) {
                List instances = this.discoveryClient.getInstances(appName);
                Map map = this.serviceRevisionInstanceMap.computeIfAbsent(appName, k -> new HashMap());
                for (ServiceInstance instance : instances) {
                    String revision2 = RevisionResolver.getRevision(instance);
                    List list2 = map.computeIfAbsent(revision2, k -> new ArrayList());
                    list2.add(instance);
                }
                if (map.size() == 0) {
                    this.logger.debug("APP {} preInited, instance siez is zero!!", (Object)appName);
                    continue;
                }
                map.forEach((revision, list) -> this.logger.debug("APP {} revision {} preInited, instance size = {}", new Object[]{appName, revision, list.size()}));
            }
            this.metadataSubscribeHandlerMap.forEach((url, handler) -> handler.init());
            this.urlSubscribeHandlerMap.forEach((url, handler) -> handler.init());
            this.repository.initializeMetadata();
            this.applicationContext.addApplicationListener((ApplicationListener)this);
            this.logger.info("DubboCloudRegistry preInit Done.");
        }
    }

    protected <T> T getBean(Class<T> beanClass) {
        return (T)this.applicationContext.getBean(beanClass);
    }

    protected boolean shouldNotRegister(URL url) {
        String side = url.getParameter("side");
        boolean should = "provider".equals(side);
        if (this.logger.isDebugEnabled()) {
            if (!should) {
                this.logger.debug("The URL should NOT!! be registered & unregistered [{}] .", (Object)url);
            } else {
                this.logger.debug("The URL should be registered & unregistered [{}] .", (Object)url);
            }
        }
        return !should;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRegister(URL url) {
        DubboCloudRegistry dubboCloudRegistry = this;
        synchronized (dubboCloudRegistry) {
            this.preInit();
            if (this.shouldNotRegister(url)) {
                return;
            }
            this.repository.exportURL(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doUnregister(URL url) {
        DubboCloudRegistry dubboCloudRegistry = this;
        synchronized (dubboCloudRegistry) {
            this.preInit();
            if (this.shouldNotRegister(url)) {
                return;
            }
            this.repository.unexportURL(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doSubscribe(URL url, NotifyListener listener) {
        DubboCloudRegistry dubboCloudRegistry = this;
        synchronized (dubboCloudRegistry) {
            this.preInit();
            if (this.isAdminURL(url)) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("This feature about admin will be supported in the future.");
                }
            } else if (this.isDubboMetadataServiceURL(url) && this.containsProviderCategory(url)) {
                String appName = this.getServiceName(url);
                MetadataServiceSubscribeHandler handler = new MetadataServiceSubscribeHandler(appName, url, listener, this, this.dubboMetadataUtils);
                if (this.inited.get()) {
                    handler.init();
                }
                this.metadataSubscribeHandlerMap.put(appName, handler);
            } else if (this.isConsumerServiceURL(url)) {
                GenearalServiceSubscribeHandler handler = new GenearalServiceSubscribeHandler(url, listener, this, this.repository, this.jsonUtils, this.dubboMetadataConfigServiceProxy);
                if (this.inited.get()) {
                    handler.init();
                }
                this.urlSubscribeHandlerMap.put(url, handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ServiceInstancesChangedEvent event) {
        String appName = event.getServiceName();
        List<ServiceInstance> instances = this.filter(event.getServiceInstances() != null ? event.getServiceInstances() : Collections.emptyList());
        Set<String> subscribedServiceNames = this.getServices(null);
        if (!subscribedServiceNames.contains(appName)) {
            return;
        }
        if (instances.size() == 0) {
            this.logger.warn("APP {} instance changed, size changed zero!!!", (Object)appName);
        } else {
            this.logger.info("APP {} instance changed, size changed to {}", (Object)appName, (Object)instances.size());
        }
        Map<String, List<ServiceInstance>> newGroup = instances.stream().collect(Collectors.groupingBy(RevisionResolver::getRevision));
        DubboCloudRegistry dubboCloudRegistry = this;
        synchronized (dubboCloudRegistry) {
            Map oldGroup = this.serviceRevisionInstanceMap.computeIfAbsent(appName, k -> new HashMap());
            if (this.serviceInstanceNotChanged(oldGroup, newGroup)) {
                this.logger.debug("APP {} instance changed, but nothing different", (Object)appName);
                return;
            }
            try {
                this.refreshServiceMetadataInfo(appName, instances);
                this.refreshGeneralServiceInfo(appName, oldGroup, newGroup);
                this.reSubscribeManager.onRefreshSuccess(event);
            }
            catch (Exception e) {
                this.logger.error(String.format("APP %s instance changed, handler faild, try resubscribe", appName), (Throwable)e);
                this.reSubscribeManager.onRefreshFail(event);
            }
        }
    }

    private void refreshGeneralServiceInfo(String appName, Map<String, List<ServiceInstance>> oldGroup, Map<String, List<ServiceInstance>> newGroup) {
        HashSet urls2refresh = new HashSet();
        for (String string : oldGroup.keySet()) {
            if (newGroup.containsKey(string)) continue;
            this.urlSubscribeHandlerMap.forEach((url, handler) -> {
                if (handler.relatedWith(appName, revision)) {
                    handler.removeAppNameWithRevision(appName, revision);
                    urls2refresh.add(url);
                }
            });
            this.logger.debug("Subscription app {} revision {} has all losted", (Object)appName, (Object)string);
        }
        for (Map.Entry entry : newGroup.entrySet()) {
            String revision = (String)entry.getKey();
            List instanceList = (List)entry.getValue();
            if (!oldGroup.containsKey(revision)) {
                this.urlSubscribeHandlerMap.forEach((url, handler) -> handler.init(appName, revision, instanceList));
            }
            this.urlSubscribeHandlerMap.forEach((url, handler) -> {
                if (handler.relatedWith(appName, revision)) {
                    urls2refresh.add(url);
                }
            });
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Subscription app {} revision {} changed, instance list {}", new Object[]{appName, revision, instanceList.stream().map(instance -> instance.getHost() + ":" + instance.getPort()).collect(Collectors.toList())});
        }
        this.serviceRevisionInstanceMap.put(appName, newGroup);
        if (urls2refresh.size() == 0) {
            this.logger.debug("Subscription app {}, no urls will be refreshed", (Object)appName);
        } else {
            this.logger.debug("Subscription app {}, the following url will be refresh:{}", (Object)appName, urls2refresh.stream().map(URL::getServiceKey).collect(Collectors.toList()));
            for (URL uRL : urls2refresh) {
                GenearalServiceSubscribeHandler handler2 = this.urlSubscribeHandlerMap.get(uRL);
                if (handler2 == null) {
                    this.logger.warn("Subscription app {}, can't find handler for service {}", (Object)appName, (Object)uRL.getServiceKey());
                    continue;
                }
                handler2.refresh();
            }
        }
    }

    private void refreshServiceMetadataInfo(String serviceName, List<ServiceInstance> serviceInstances) {
        MetadataServiceSubscribeHandler handler = this.metadataSubscribeHandlerMap.get(serviceName);
        if (handler == null) {
            this.logger.warn("Subscription app {}, can't find metadata handler", (Object)serviceName);
            return;
        }
        handler.refresh(serviceInstances);
    }

    private boolean serviceInstanceNotChanged(Map<String, List<ServiceInstance>> oldGroup, Map<String, List<ServiceInstance>> newGroup) {
        if (newGroup.size() != oldGroup.size()) {
            return false;
        }
        for (Map.Entry<String, List<ServiceInstance>> entry : newGroup.entrySet()) {
            String appName = entry.getKey();
            List<ServiceInstance> newInstances = entry.getValue();
            if (!oldGroup.containsKey(appName)) {
                return false;
            }
            List<ServiceInstance> oldInstances = oldGroup.get(appName);
            if (newInstances.size() != oldInstances.size()) {
                return false;
            }
            boolean matched = newInstances.stream().allMatch(newInstance -> {
                for (ServiceInstance oldInstance : oldInstances) {
                    if (!this.instanceSame((ServiceInstance)newInstance, oldInstance)) continue;
                    return true;
                }
                return false;
            });
            if (matched) continue;
            return false;
        }
        return true;
    }

    private boolean instanceSame(ServiceInstance newInstance, ServiceInstance oldInstance) {
        if (!StringUtils.equals((CharSequence)newInstance.getInstanceId(), (CharSequence)oldInstance.getInstanceId())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)newInstance.getHost(), (CharSequence)oldInstance.getHost())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)newInstance.getServiceId(), (CharSequence)oldInstance.getServiceId())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)newInstance.getScheme(), (CharSequence)oldInstance.getScheme())) {
            return false;
        }
        if (oldInstance.getPort() != newInstance.getPort()) {
            return false;
        }
        return oldInstance.getMetadata().equals(newInstance.getMetadata());
    }

    private List<ServiceInstance> filter(Collection<ServiceInstance> serviceInstances) {
        return serviceInstances.stream().filter(this::isDubboServiceInstance).collect(Collectors.toList());
    }

    private boolean isDubboServiceInstance(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        return metadata.containsKey("dubbo.metadata-service.urls");
    }

    private Set<String> getServices(URL url) {
        Set<String> subscribedServices = this.repository.getSubscribedServices();
        if (subscribedServices.contains("*")) {
            subscribedServices = new HashSet<String>(this.discoveryClient.getServices());
        }
        return subscribedServices;
    }

    List<ServiceInstance> getServiceInstances(String serviceName) {
        return org.springframework.util.StringUtils.hasText((String)serviceName) ? this.doGetServiceInstances(serviceName) : Collections.emptyList();
    }

    private List<ServiceInstance> doGetServiceInstances(String serviceName) {
        List serviceInstances;
        block2: {
            serviceInstances = Collections.emptyList();
            try {
                serviceInstances = this.discoveryClient.getInstances(serviceName);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return serviceInstances;
    }

    private String getServiceName(URL subscribedURL) {
        return subscribedURL.getParameter("group");
    }

    private boolean containsProviderCategory(URL subscribedURL) {
        String category = subscribedURL.getParameter("category");
        return category != null && category.contains("provider");
    }

    public final void doUnsubscribe(URL url, NotifyListener listener) {
    }

    public boolean isAvailable() {
        return !this.discoveryClient.getServices().isEmpty();
    }

    protected boolean isAdminURL(URL url) {
        return "admin".equals(url.getProtocol());
    }

    protected boolean isDubboMetadataServiceURL(URL url) {
        return DUBBO_METADATA_SERVICE_CLASS_NAME.equals(url.getServiceInterface());
    }

    protected boolean isConsumerServiceURL(URL url) {
        return "consumer".equals(url.getProtocol());
    }

    public List<ServiceInstance> getServiceInstances(Map<String, Set<String>> providers) {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        providers.forEach((appName, revisions) -> {
            Map<String, List<ServiceInstance>> revisionMap = this.serviceRevisionInstanceMap.get(appName);
            if (revisionMap == null) {
                return;
            }
            for (String revision : revisions) {
                List<ServiceInstance> list = revisionMap.get(revision);
                if (list == null) continue;
                instances.addAll(list);
            }
        });
        return instances;
    }

    public Map<String, Map<String, List<ServiceInstance>>> getServiceRevisionInstanceMap() {
        return this.serviceRevisionInstanceMap;
    }
}

