/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.service;

import com.alibaba.cloud.dubbo.metadata.DubboRestServiceMetadata;
import com.alibaba.cloud.dubbo.metadata.ServiceRestMetadata;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

public class DubboGenericServiceFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, ReferenceBean<GenericService>> cache = new ConcurrentHashMap<String, ReferenceBean<GenericService>>();
    @Autowired
    private ObjectProvider<List<RegistryConfig>> registryConfigs;

    public GenericService create(DubboRestServiceMetadata dubboServiceMetadata, Map<String, Object> dubboTranslatedAttributes) {
        ReferenceBean<GenericService> referenceBean = this.build(dubboServiceMetadata.getServiceRestMetadata(), dubboTranslatedAttributes);
        return referenceBean == null ? null : (GenericService)referenceBean.get();
    }

    public GenericService create(String serviceName, Class<?> serviceClass, String version) {
        String interfaceName = serviceClass.getName();
        ReferenceBean<GenericService> referenceBean = this.build(interfaceName, version, serviceName, Collections.emptyMap());
        if (DubboMetadataService.class == serviceClass) {
            referenceBean.setRouter("-default,revisionRouter");
        }
        return (GenericService)referenceBean.get();
    }

    private ReferenceBean<GenericService> build(ServiceRestMetadata serviceRestMetadata, Map<String, Object> dubboTranslatedAttributes) {
        String urlValue = serviceRestMetadata.getUrl();
        URL url = URL.valueOf((String)urlValue);
        String interfaceName = url.getServiceInterface();
        String version = url.getParameter("version");
        String group = url.getParameter("group");
        return this.build(interfaceName, version, group, dubboTranslatedAttributes);
    }

    private ReferenceBean<GenericService> build(String interfaceName, String version, String group, Map<String, Object> dubboTranslatedAttributes) {
        String key = this.createKey(interfaceName, version, group, dubboTranslatedAttributes);
        return this.cache.computeIfAbsent(key, k -> {
            ReferenceBean referenceBean = new ReferenceBean();
            referenceBean.setGeneric(Boolean.valueOf(true));
            referenceBean.setInterface(interfaceName);
            referenceBean.setVersion(version);
            referenceBean.setGroup(group);
            referenceBean.setCheck(Boolean.valueOf(false));
            this.bindReferenceBean((ReferenceBean<GenericService>)referenceBean, dubboTranslatedAttributes);
            return referenceBean;
        });
    }

    private String createKey(String interfaceName, String version, String group, Map<String, Object> dubboTranslatedAttributes) {
        return group + "#" + Objects.hash(interfaceName, version, group, dubboTranslatedAttributes);
    }

    private void bindReferenceBean(ReferenceBean<GenericService> referenceBean, Map<String, Object> dubboTranslatedAttributes) {
        DataBinder dataBinder = new DataBinder(referenceBean);
        dataBinder.registerCustomEditor(String.class, "filter", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(String.class, "listener", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(Map.class, "parameters", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) throws IllegalArgumentException {
                String content = StringUtils.trimAllWhitespace((String)text);
                if (!StringUtils.hasText((String)content)) {
                    return;
                }
                content = StringUtils.replace((String)content, (String)"=", (String)",");
                content = StringUtils.replace((String)content, (String)":", (String)",");
                Map parameters = CollectionUtils.toStringMap((String[])StringUtils.commaDelimitedListToStringArray((String)content));
                this.setValue(parameters);
            }
        });
        dataBinder.setDisallowedFields(new String[]{"registries"});
        dataBinder.bind((PropertyValues)new MutablePropertyValues(dubboTranslatedAttributes));
        this.registryConfigs.ifAvailable(arg_0 -> referenceBean.setRegistries(arg_0));
    }

    @PreDestroy
    public void destroy() {
        this.destroyReferenceBeans();
        this.cache.clear();
    }

    public void destroy(String serviceName) {
        HashSet removeGroups = new HashSet(this.cache.keySet());
        for (String key : removeGroups) {
            if (!key.contains(serviceName)) continue;
            ReferenceBean referenceBean = (ReferenceBean)this.cache.remove(key);
            referenceBean.destroy();
        }
    }

    private void destroyReferenceBeans() {
        Collection referenceBeans = this.cache.values();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The Dubbo GenericService ReferenceBeans are destroying...");
        }
        for (ReferenceBean referenceBean : referenceBeans) {
            referenceBean.destroy();
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Destroyed the ReferenceBean  : {} ", (Object)referenceBean);
        }
    }
}

