/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.dubbo.common.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JSONUtils {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper objectMapper = new ObjectMapper();

    @PostConstruct
    public void init() {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public String toJSON(Collection<URL> urls) {
        return this.toJSON((Object)urls.stream().map(URL::toFullString).collect(Collectors.toSet()));
    }

    public String toJSON(Object object) {
        String jsonContent;
        block2: {
            jsonContent = null;
            try {
                jsonContent = this.objectMapper.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return jsonContent;
    }

    public List<URL> toURLs(String urlsJSON) {
        List<String> list = this.toList(urlsJSON);
        return list.stream().map(URL::valueOf).collect(Collectors.toList());
    }

    public List<String> toList(String json) {
        List list;
        block3: {
            list = Collections.emptyList();
            try {
                if (StringUtils.hasText((String)json)) {
                    list = (List)this.objectMapper.readValue(json, List.class);
                }
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }
}

